/*
 * Decompiled with CFR 0.152.
 */
package erebus.items;

import com.google.common.collect.HashMultimap;
import erebus.ModItems;
import erebus.ModTabs;
import erebus.api.IErebusEnum;
import erebus.items.ItemMaterials;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.NonNullList;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemSmoothie
extends ItemFood
implements ModItems.ISubItemsItem {
    public ItemSmoothie() {
        super(3, 0.5f, false);
        this.func_77656_e(0);
        this.func_77848_i();
        this.func_77627_a(true);
        this.func_77637_a(ModTabs.ITEMS);
    }

    public boolean hasContainerItem(ItemStack stack) {
        return true;
    }

    public ItemStack getContainerItem(ItemStack stack) {
        return ItemMaterials.EnumErebusMaterialsType.SMOOTHIE_GLASS.createStack();
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.DRINK;
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entityLiving) {
        super.func_77654_b(stack, world, entityLiving);
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (stack.func_190916_E() >= 0 && !player.field_71071_by.func_70441_a(this.getContainerItem(stack))) {
                player.func_71019_a(this.getContainerItem(stack), false);
            }
        }
        return stack;
    }

    protected void func_77849_c(ItemStack stack, World world, EntityPlayer player) {
        if (!world.field_72995_K) {
            SmoothieType type = SmoothieType.values()[stack.func_77952_i()];
            PotionEffect[] effects = type.getPotionEffects();
            if (effects != null && effects.length > 0) {
                for (PotionEffect effect : effects) {
                    player.func_70690_d(new PotionEffect(effect));
                }
            }
            type.onDrunk(player);
        }
    }

    public int func_150905_g(ItemStack stack) {
        return SmoothieType.values()[stack.func_77952_i()].getHealAmount();
    }

    public float func_150906_h(ItemStack stack) {
        return SmoothieType.values()[stack.func_77952_i()].getSaturationModifier();
    }

    public String func_77667_c(ItemStack stack) {
        int meta = stack.func_77952_i();
        meta = Math.min(Math.max(meta, 0), SmoothieType.values().length - 1);
        return super.func_77658_a() + "." + SmoothieType.values()[meta].name().toLowerCase();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> list, ITooltipFlag flag) {
        PotionEffect[] effects;
        SmoothieType type = SmoothieType.values()[stack.func_77952_i()];
        String extraEffect = type.getExtraEffect();
        if (extraEffect != null) {
            list.add(TextFormatting.YELLOW + new TextComponentTranslation("erebus.smoothie.effect." + extraEffect, new Object[0]).func_150254_d());
        }
        if ((effects = type.getPotionEffects()) != null && effects.length > 0) {
            HashMultimap attributes = HashMultimap.create();
            for (PotionEffect effect : effects) {
                String str = new TextComponentTranslation(effect.func_76453_d(), new Object[0]).func_150254_d().trim();
                Potion potion = effect.func_188419_a();
                Map map = potion.func_111186_k();
                if (map != null && map.size() > 0) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier modifier = (AttributeModifier)entry.getValue();
                        attributes.put((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)new AttributeModifier(modifier.func_111166_b(), potion.func_111183_a(effect.func_76458_c(), modifier), modifier.func_111169_c()));
                    }
                }
                if (effect.func_76458_c() > 0) {
                    str = str + " " + (potion.func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE) + new TextComponentTranslation("potion.potency." + effect.func_76458_c(), new Object[0]).func_150254_d().trim();
                }
                if (effect.func_76459_b() > 20) {
                    str = str + (potion.func_76398_f() ? TextFormatting.RED : TextFormatting.BLUE) + " (" + StringUtils.func_76337_a((int)effect.func_76459_b()) + ")";
                }
                if (potion.func_76398_f()) {
                    list.add(TextFormatting.RED + str);
                    continue;
                }
                list.add(TextFormatting.BLUE + str);
            }
            if (!attributes.isEmpty()) {
                list.add("");
                list.add(TextFormatting.DARK_PURPLE + new TextComponentTranslation("potion.whenDrank", new Object[0]).func_150254_d());
                for (Map.Entry entry : attributes.entries()) {
                    AttributeModifier modifier = (AttributeModifier)entry.getValue();
                    double amount0 = modifier.func_111164_d();
                    double amount1 = modifier.func_111169_c() != 1 && modifier.func_111169_c() != 2 ? modifier.func_111164_d() : modifier.func_111164_d() * 100.0;
                    if (amount0 > 0.0) {
                        list.add(TextFormatting.BLUE + new TextComponentTranslation("attribute.modifier.plus." + modifier.func_111169_c(), new Object[]{ItemStack.field_111284_a.format(amount1), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0])}).func_150254_d());
                        continue;
                    }
                    if (!(amount0 < 0.0)) continue;
                    list.add(TextFormatting.RED + new TextComponentTranslation("attribute.modifier.take." + modifier.func_111169_c(), new Object[]{ItemStack.field_111284_a.format(amount1 *= -1.0), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0])}).func_150254_d());
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (tab == ModTabs.ITEMS) {
            for (SmoothieType type : SmoothieType.values()) {
                list.add((Object)type.createStack(1));
            }
        }
    }

    @Override
    public List<String> getModels() {
        ArrayList<String> models = new ArrayList<String>();
        for (SmoothieType type : SmoothieType.values()) {
            models.add(type.func_176610_l());
        }
        return models;
    }

    public static enum SmoothieType implements IErebusEnum
    {
        GREEN_TEA_GRASSHOPPER(5, 0.4f, new PotionEffect(MobEffects.field_76430_j, 1000, 2)),
        MONEY_HONEY(3, 0.2f, new PotionEffect(MobEffects.field_76428_l, 200, 2)),
        NOTHING_IN_THE_MIDDLE(1, 0.0f, new PotionEffect(MobEffects.field_76441_p, 500, 1)),
        GREEN_GIANT(2, 0.1f, new PotionEffect[0]),
        SEEDY_GOODNESS(1, 1.1f, new PotionEffect(MobEffects.field_76422_e, 500, 1)),
        GIVIN_ME_THE_BLUES(3, 0.2f, new PotionEffect(MobEffects.field_76421_d, 500, 2)),
        HOT_HOT_BABY(2, 0.1f, new PotionEffect(MobEffects.field_76420_g, 1000, 1)),
        DONT_MEDDLE_WITH_THE_NETTLE(2, 0.1f, new PotionEffect(MobEffects.field_76429_m, 1000, 1)),
        LIQUID_GOLD(0, 0.0f, new PotionEffect(MobEffects.field_76428_l, 1000, 1)),
        BRYUFS_BREW(2, 0.0f, new PotionEffect(MobEffects.field_76420_g, 1000, 2), new PotionEffect(MobEffects.field_76430_j, 1000, 2), new PotionEffect(MobEffects.field_76424_c, 1000, 2), new PotionEffect(MobEffects.field_76439_r, 1000, 1));

        private final int healAmount;
        private final float saturationModifier;
        private final PotionEffect[] effects;

        private SmoothieType(int healAmount, float saturationModifier, PotionEffect ... effects) {
            this.healAmount = healAmount;
            this.saturationModifier = saturationModifier;
            this.effects = effects;
        }

        public PotionEffect[] getPotionEffects() {
            return this.effects;
        }

        public float getSaturationModifier() {
            return this.saturationModifier;
        }

        public int getHealAmount() {
            return this.healAmount;
        }

        @Override
        public ItemStack createStack(int size) {
            return new ItemStack(ModItems.SMOOTHIE, size, this.ordinal());
        }

        public String func_176610_l() {
            return "smoothie_" + this.name().toLowerCase(Locale.ENGLISH);
        }

        public String getExtraEffect() {
            switch (this) {
                case GREEN_GIANT: {
                    return "milk";
                }
                case GIVIN_ME_THE_BLUES: {
                    return "extinguish";
                }
                case HOT_HOT_BABY: {
                    return "set_fire";
                }
                case LIQUID_GOLD: {
                    return "heal";
                }
                case BRYUFS_BREW: {
                    return "heal";
                }
            }
            return null;
        }

        public void onDrunk(EntityPlayer player) {
            switch (this) {
                case GREEN_GIANT: {
                    player.curePotionEffects(new ItemStack(Items.field_151117_aB));
                    break;
                }
                case GIVIN_ME_THE_BLUES: {
                    player.func_70066_B();
                    break;
                }
                case HOT_HOT_BABY: {
                    player.func_70015_d(5);
                    break;
                }
                case LIQUID_GOLD: {
                    player.func_70691_i(0.5f);
                    break;
                }
                case BRYUFS_BREW: {
                    player.func_70691_i(1.5f);
                    break;
                }
            }
        }
    }
}

