/*
 * Decompiled with CFR 0.152.
 */
package erebus.network.client;

import erebus.core.capabilities.base.EntityCapability;
import erebus.core.capabilities.base.EntityCapabilityHandler;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MessageSyncEntityCapabilities
implements IMessage,
IMessageHandler<MessageSyncEntityCapabilities, MessageSyncEntityCapabilities> {
    private ResourceLocation capability;
    private NBTTagCompound nbt;
    private int entityID;

    public MessageSyncEntityCapabilities() {
    }

    public MessageSyncEntityCapabilities(EntityCapability<?, ?, ?> entityCapability) {
        this.capability = entityCapability.getID();
        this.entityID = entityCapability.getEntity().func_145782_y();
        this.nbt = new NBTTagCompound();
        entityCapability.writeTrackingDataToNBT(this.nbt);
    }

    private Entity getEntity(World world) {
        return world.func_73045_a(this.entityID);
    }

    public MessageSyncEntityCapabilities onMessage(final MessageSyncEntityCapabilities message, MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            Minecraft mc = FMLClientHandler.instance().getClient();
            mc.func_152344_a(new Runnable(){

                @Override
                public void run() {
                    MessageSyncEntityCapabilities.this.handleMessage(message);
                }
            });
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handleMessage(MessageSyncEntityCapabilities message) {
        EntityCapability<?, ?, Entity> capability;
        WorldClient world = Minecraft.func_71410_x().field_71441_e;
        Entity entity = world.func_73045_a(message.entityID);
        if (entity != null && (capability = EntityCapabilityHandler.getCapability(message.capability, entity)) != null) {
            capability.readTrackingDataFromNBT(message.nbt);
        }
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBuffer buf = new PacketBuffer(buffer);
        this.capability = new ResourceLocation(buf.func_150789_c(128));
        this.entityID = buf.readInt();
        try {
            this.nbt = buf.func_150793_b();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void toBytes(ByteBuf buffer) {
        PacketBuffer buf = new PacketBuffer(buffer);
        buf.func_180714_a(this.capability.toString());
        buf.writeInt(this.entityID);
        buf.func_150786_a(this.nbt);
    }
}

