/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.biomes;

import erebus.ModBiomes;
import erebus.ModBlocks;
import erebus.core.handler.configs.ConfigHandler;
import erebus.world.SpawnerErebus;
import erebus.world.biomes.decorators.BiomeDecoratorBaseErebus;
import erebus.world.loot.IWeightProvider;
import erebus.world.loot.WeightedList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BiomeBaseErebus
extends Biome
implements IWeightProvider {
    private final BiomeDecoratorBaseErebus decorator;
    public static short biomeWeight;
    public int grassColor;
    public int foliageColor;
    private short[] fogColorRGB = new short[]{255, 255, 255};
    public byte topBlockMeta;
    public byte fillerBlockMeta;
    protected final WeightedList<SpawnerErebus.SpawnEntry> spawningGradual = new WeightedList();
    protected final WeightedList<SpawnerErebus.SpawnEntry> spawningPopulate = new WeightedList();

    public BiomeBaseErebus(Biome.BiomeProperties properties, BiomeDecoratorBaseErebus decorator) {
        super(properties);
        this.decorator = decorator;
        this.field_76761_J.clear();
        this.field_76762_K.clear();
        this.field_76755_L.clear();
        this.field_82914_M.clear();
        this.spawningPopulate.clear();
        this.spawningGradual.clear();
        this.topBlockMeta = 0;
        this.fillerBlockMeta = 0;
    }

    public boolean func_76738_d() {
        return false;
    }

    protected final BiomeBaseErebus setColors(int grassAndFoliage) {
        this.setColors(grassAndFoliage, grassAndFoliage);
        return this;
    }

    protected final BiomeBaseErebus setColors(int grass, int foliage) {
        this.grassColor = grass;
        this.foliageColor = foliage;
        return this;
    }

    protected final BiomeBaseErebus setFog(int red, int green, int blue) {
        this.fogColorRGB = ConfigHandler.INSTANCE.biomeFogColours ? new short[]{(short)red, (short)green, (short)blue} : new short[]{0, 0, 0};
        return this;
    }

    protected final BiomeBaseErebus setWeight(int weight) {
        if (biomeWeight != 0) {
            throw new RuntimeException("Cannot set biome weight twice!");
        }
        biomeWeight = (short)weight;
        if (this.getClass().getGenericSuperclass() == BiomeBaseErebus.class) {
            ModBiomes.BIOME_LIST.add(this);
        }
        return this;
    }

    public SpawnerErebus.SpawnEntry getRandomSpawnGradual(Random rand) {
        return this.spawningGradual.getRandomItem(rand);
    }

    public SpawnerErebus.SpawnEntry getRandomSpawnPopulate(Random rand) {
        return this.spawningPopulate.getRandomItem(rand);
    }

    @SideOnly(value=Side.CLIENT)
    public int getModdedBiomeGrassColor(int original) {
        return this.grassColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180627_b(BlockPos pos) {
        return this.grassColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int getModdedBiomeFoliageColor(int original) {
        return this.foliageColor;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_180625_c(BlockPos pos) {
        return this.foliageColor;
    }

    @SideOnly(value=Side.CLIENT)
    public final short[] getFogRGB() {
        return this.fogColorRGB;
    }

    @Override
    public final short getWeight() {
        return biomeWeight;
    }

    public void populate(World world, Random rand, int x, int z) {
        this.decorator.populate(world, rand, x, z);
    }

    public void decorate(World world, Random rand, int x, int z) {
        this.decorator.decorate(world, rand, x, z);
    }

    public Block placeCaveBlock(Block block, int x, int y, int z, Random rand) {
        return block == ModBlocks.UMBERSTONE || block == this.field_76752_A || block == this.field_76753_B || block == Blocks.field_150322_A ? Blocks.field_150350_a : block;
    }
}

