/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.plant;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenBigLogs
extends WorldGenerator {
    private int length = -1;
    private int baseRadius = -1;
    private EnumFacing facing;
    protected IBlockState log;
    protected IBlockState core;
    protected IBlockState ore;
    private boolean genOres;

    public WorldGenBigLogs(int length, int baseRadius, EnumFacing facing, IBlockState outerLayer, IBlockState innerLayer, boolean generateOres, IBlockState innerOre) {
        this.length = length;
        this.baseRadius = baseRadius;
        this.facing = facing;
        this.log = outerLayer;
        this.core = innerLayer;
        this.ore = innerOre;
        this.genOres = generateOres;
    }

    public WorldGenBigLogs(int length, int baseRadius, EnumFacing facing, IBlockState outerLayer) {
        this.length = length;
        this.baseRadius = baseRadius;
        this.facing = facing;
        this.core = this.ore = outerLayer;
        this.log = this.ore;
        this.genOres = false;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (this.facing == EnumFacing.NORTH || this.facing == EnumFacing.SOUTH) {
            for (int xx = x - this.baseRadius; this.baseRadius + x >= xx; ++xx) {
                for (int zz = z - this.length; this.length + z - 1 >= zz; ++zz) {
                    for (int yy = y + 1; yy <= y + this.baseRadius * 2; ++yy) {
                        if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                        return false;
                    }
                }
            }
            for (int zz = z - this.length; this.length + z - 1 >= zz; ++zz) {
                for (int i = this.baseRadius * -1; i <= this.baseRadius; ++i) {
                    for (int j = this.baseRadius * -1; j <= this.baseRadius; ++j) {
                        double dSq = i * i + j * j;
                        if (Math.round(Math.sqrt(dSq)) == (long)this.baseRadius) {
                            world.func_175656_a(new BlockPos(x + i, y + j + this.baseRadius, zz), this.log);
                            if (rand.nextInt(12) == 0) {
                                world.func_175698_g(new BlockPos(x + i, y + j + this.baseRadius, zz));
                            }
                            if ((zz != z - this.length || rand.nextInt(2) != 0) && (zz != z + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(new BlockPos(x + i, y + j + this.baseRadius, zz));
                            continue;
                        }
                        if (Math.round(Math.sqrt(dSq)) < (long)this.baseRadius && this.genOres) {
                            world.func_175656_a(new BlockPos(x + i, y + j + this.baseRadius, zz), rand.nextInt(6) == 0 ? this.ore : this.core);
                            if ((zz != z - this.length || rand.nextInt(2) != 0) && (zz != z + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(new BlockPos(x + i, y + j + this.baseRadius, zz));
                            continue;
                        }
                        world.func_175698_g(new BlockPos(x + i, y + j + this.baseRadius, zz));
                    }
                }
            }
        } else {
            int xx;
            for (xx = x - this.length; this.length + x - 1 >= xx; ++xx) {
                for (int zz = z - this.baseRadius; this.baseRadius + z >= zz; ++zz) {
                    for (int yy = y + 1; yy <= y + this.baseRadius * 2; ++yy) {
                        if (world.func_175623_d(new BlockPos(xx, yy, zz))) continue;
                        return false;
                    }
                }
            }
            for (xx = x - this.length; this.length + x - 1 >= xx; ++xx) {
                for (int i = this.baseRadius * -1; i <= this.baseRadius; ++i) {
                    for (int j = this.baseRadius * -1; j <= this.baseRadius; ++j) {
                        double dSq = i * i + j * j;
                        if (Math.round(Math.sqrt(dSq)) == (long)this.baseRadius) {
                            world.func_175656_a(new BlockPos(xx, y + j + this.baseRadius, z + i), this.log);
                            if (rand.nextInt(12) == 0) {
                                world.func_175698_g(new BlockPos(xx, y + j + this.baseRadius, z + i));
                            }
                            if ((xx != x - this.length || rand.nextInt(2) != 0) && (xx != x + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(new BlockPos(xx, y + j + this.baseRadius, z + i));
                            continue;
                        }
                        if (Math.round(Math.sqrt(dSq)) < (long)this.baseRadius && this.genOres) {
                            world.func_175656_a(new BlockPos(xx, y + j + this.baseRadius, z + i), rand.nextInt(6) == 0 ? this.ore : this.core);
                            if ((xx != x - this.length || rand.nextInt(2) != 0) && (xx != x + this.length - 1 || rand.nextInt(2) != 0)) continue;
                            world.func_175698_g(new BlockPos(xx, y + j + this.baseRadius, z + i));
                            continue;
                        }
                        world.func_175698_g(new BlockPos(xx, y + j + this.baseRadius, z + i));
                    }
                }
            }
        }
        return true;
    }
}

