/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.plant;

import erebus.ModBlocks;
import erebus.blocks.BlockWallPlants;
import erebus.blocks.EnumWood;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public class WorldGenMossPatch
extends WorldGenerator {
    boolean blockPlaced = false;
    private int mossType = -1;

    public WorldGenMossPatch(int type) {
        super(true);
        this.mossType = type;
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        this.placeBlockAt(world, rand, pos);
        if (this.blockPlaced) {
            this.createPatch(world, rand, pos);
        }
        return true;
    }

    private void placeBlockAt(World world, Random rand, BlockPos pos) {
        boolean offset = true;
        IBlockState state = ModBlocks.WALL_PLANTS.func_176223_P();
        int randomiseSide = rand.nextInt(6);
        switch (randomiseSide) {
            case 0: {
                if (!world.isSideSolid(pos.func_177984_a(), EnumFacing.DOWN) || !this.isValidBlock(world, pos.func_177984_a())) break;
                world.func_180501_a(pos, this.mossType == 0 ? state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOSS_DOWN)) : state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOULD_DOWN)), 2);
                this.blockPlaced = true;
                break;
            }
            case 1: {
                if (!world.isSideSolid(pos.func_177977_b(), EnumFacing.UP) || !this.isValidBlock(world, pos.func_177977_b())) break;
                world.func_180501_a(pos, this.mossType == 0 ? state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOSS_UP)) : state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOULD_UP)), 2);
                this.blockPlaced = true;
                break;
            }
            case 2: {
                if (!world.isSideSolid(pos.func_177968_d(), EnumFacing.NORTH) || !this.isValidBlock(world, pos.func_177968_d())) break;
                world.func_180501_a(pos, this.mossType == 0 ? state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOSS_NORTH)) : state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOULD_NORTH)), 2);
                this.blockPlaced = true;
                break;
            }
            case 3: {
                if (!world.isSideSolid(pos.func_177978_c(), EnumFacing.SOUTH) || !this.isValidBlock(world, pos.func_177978_c())) break;
                world.func_180501_a(pos, this.mossType == 0 ? state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOSS_SOUTH)) : state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOULD_SOUTH)), 2);
                this.blockPlaced = true;
                break;
            }
            case 4: {
                if (!world.isSideSolid(pos.func_177974_f(), EnumFacing.WEST) || !this.isValidBlock(world, pos.func_177974_f())) break;
                world.func_180501_a(pos, this.mossType == 0 ? state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOSS_WEST)) : state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOULD_WEST)), 2);
                this.blockPlaced = true;
                break;
            }
            case 5: {
                if (!world.isSideSolid(pos.func_177976_e(), EnumFacing.EAST) || !this.isValidBlock(world, pos.func_177976_e())) break;
                world.func_180501_a(pos, this.mossType == 0 ? state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOSS_EAST)) : state.func_177226_a(BlockWallPlants.TYPE, (Comparable)((Object)BlockWallPlants.EnumWallPlantType.MOULD_EAST)), 2);
                this.blockPlaced = true;
                break;
            }
            default: {
                this.blockPlaced = false;
            }
        }
    }

    private void createPatch(World world, Random rand, BlockPos pos) {
        int radius = 2;
        for (int xx = -radius; xx <= radius; ++xx) {
            for (int zz = -radius; zz <= radius; ++zz) {
                for (int yy = -radius; yy <= radius; ++yy) {
                    if (!world.func_175623_d(pos.func_177982_a(xx, yy, zz))) continue;
                    for (int attempt = 0; attempt < 3; ++attempt) {
                        this.placeBlockAt(world, rand, pos.func_177982_a(xx, yy, zz));
                    }
                }
            }
        }
    }

    private boolean isValidBlock(World world, BlockPos pos) {
        return world.func_180495_p(pos).func_177230_c() == EnumWood.ROTTEN.getLog() || world.func_180495_p(pos).func_177230_c() == ModBlocks.UMBERSTONE;
    }
}

