/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.structure;

import erebus.ModBlocks;
import erebus.ModFluids;
import erebus.ModItems;
import erebus.items.ItemErebusFood;
import erebus.items.ItemMaterials;
import erebus.world.biomes.decorators.data.SurfaceType;
import erebus.world.loot.IPostProcess;
import erebus.world.loot.LootItemStack;
import erebus.world.loot.LootUtil;
import erebus.world.loot.WeightedLootList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;

public class WorldGenDungPile
extends WorldGenerator {
    public int height = 5;
    public int radius = 5;
    public IBlockState DUNG = ModBlocks.DUNG.func_176223_P();
    public static final WeightedLootList CHEST_LOOT = new WeightedLootList(new LootItemStack[]{new LootItemStack(ModItems.MATERIALS).setAmount(1, 3).setDamage(ItemMaterials.EnumErebusMaterialsType.JADE.ordinal()).setWeight(10), new LootItemStack(ModItems.MATERIALS).setAmount(4, 8).setDamage(ItemMaterials.EnumErebusMaterialsType.PLATE_EXO.ordinal()).setWeight(9), new LootItemStack(Items.field_151134_bR).setWeight(8), new LootItemStack(Items.field_151035_b).setWeight(2), new LootItemStack(ModItems.JADE_PICKAXE).setWeight(1), new LootItemStack(Items.field_151037_a).setWeight(2), new LootItemStack(ModItems.JADE_SHOVEL).setWeight(1), new LootItemStack(Items.field_151036_c).setWeight(2), new LootItemStack(ModItems.JADE_AXE).setWeight(1), new LootItemStack(Items.field_151040_l).setWeight(2), new LootItemStack(ModItems.JADE_SWORD).setWeight(1), new LootItemStack((Item)Items.field_151030_Z).setWeight(2), new LootItemStack(ModItems.JADE_CHESTPLATE).setWeight(1), new LootItemStack((Item)Items.field_151028_Y).setWeight(2), new LootItemStack(ModItems.JADE_HELMET).setWeight(1), new LootItemStack((Item)Items.field_151165_aa).setWeight(2), new LootItemStack(ModItems.JADE_LEGGINGS).setWeight(1), new LootItemStack((Item)Items.field_151167_ab).setWeight(2), new LootItemStack(ModItems.JADE_BOOTS).setWeight(1), new LootItemStack((Item)ModItems.EXOSKELETON_SHIELD).setAmount(1).setWeight(3), new LootItemStack((Item)ModItems.BAMBOO_SHIELD).setAmount(1).setWeight(3), new LootItemStack(ModItems.ANTI_VENOM_BOTTLE).setAmount(1, 3).setWeight(8), new LootItemStack(ModItems.SPRAY_CAN).setAmount(3, 6).setWeight(5), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.SCORPION_PINCER.ordinal()).setWeight(1), new LootItemStack(ModItems.MATERIALS).setAmount(1, 3).setDamage(ItemMaterials.EnumErebusMaterialsType.REINFORCED_PLATE_EXO.ordinal()).setWeight(4), new LootItemStack(ModItems.MATERIALS).setAmount(3, 9).setDamage(ItemMaterials.EnumErebusMaterialsType.AMBER_STAR.ordinal()).setWeight(6), new LootItemStack(ModItems.MATERIALS).setAmount(1).setDamage(ItemMaterials.EnumErebusMaterialsType.BEETLE_RIDING_KIT.ordinal()).setWeight(1), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 3).setDamage(ItemErebusFood.EnumFoodType.TITAN_CHOP_RAW.ordinal()).setWeight(6), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 2).setDamage(ItemErebusFood.EnumFoodType.TITAN_CHOP_COOKED.ordinal()).setWeight(4), new LootItemStack(ModItems.STAG_HEART_RAW).setAmount(1).setWeight(1), new LootItemStack(ModItems.BAMBUCKET).setAmount(1).setWeight(3), new LootItemStack(ModItems.CABBAGE_SEEDS).setAmount(3).setWeight(5), new LootItemStack(ModItems.EREBUS_FOOD).setAmount(1, 3).setDamage(ItemErebusFood.EnumFoodType.CABBAGE.ordinal()).setWeight(10)}).setPostProcessor(new IPostProcess(){

        @Override
        public ItemStack postProcessItem(ItemStack is, Random rand) {
            if (is.func_77973_b() == Items.field_151134_bR || rand.nextBoolean() && (is.func_77973_b() instanceof ItemTool || is.func_77973_b() instanceof ItemArmor || is.func_77973_b() instanceof ItemSword)) {
                boolean enchBook;
                boolean bl = enchBook = is.func_77973_b() == Items.field_151134_bR;
                if (enchBook) {
                    is = new ItemStack(Items.field_151122_aG);
                }
                List enchList = EnchantmentHelper.func_77513_b((Random)rand, (ItemStack)is, (int)(7 + rand.nextInt(10)), (boolean)true);
                if (enchBook) {
                    is = new ItemStack(Items.field_151134_bR);
                }
                if (enchList != null && enchList.size() > 0) {
                    for (int a = 0; a < enchList.size(); ++a) {
                        EnchantmentData data = (EnchantmentData)enchList.get(a);
                        is.func_77966_a(data.field_76302_b, data.field_76303_c);
                    }
                }
            }
            if (is.func_77973_b() == ModItems.BAMBUCKET) {
                int randomBucket = rand.nextInt(2);
                switch (randomBucket) {
                    case 0: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"beetle_juice"), 1000));
                        break;
                    }
                    case 1: {
                        is = ModFluids.getFilledBambucket(new FluidStack(FluidRegistry.getFluid((String)"honey"), 1000));
                    }
                }
            }
            return is;
        }
    });

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        if (!this.aircheck(world, rand, pos)) {
            return false;
        }
        for (int xx = -this.radius; xx <= this.radius; ++xx) {
            for (int zz = -this.radius; zz <= this.radius; ++zz) {
                for (int yy = 0; yy < this.height; ++yy) {
                    double dSqDome = Math.pow(xx, 2.0) + Math.pow(zz, 2.0) + Math.pow(yy, 2.0);
                    if (yy == 0 && rand.nextBoolean() && Math.round(Math.sqrt(dSqDome)) == 5L) {
                        world.func_180501_a(pos.func_177982_a(xx, -1, zz), this.DUNG, 2);
                    }
                    if (Math.round(Math.sqrt(dSqDome)) >= 5L) continue;
                    world.func_180501_a(pos.func_177982_a(xx, yy, zz), this.DUNG, 2);
                }
                if (rand.nextInt(5) != 0) continue;
                world.func_180501_a(pos.func_177982_a(xx, 0, zz), this.DUNG, 2);
            }
        }
        world.func_180501_a(pos, Blocks.field_150486_ae.func_176203_a(0), 2);
        TileEntityChest chest = (TileEntityChest)world.func_175625_s(pos);
        if (chest != null) {
            LootUtil.generateLoot((IInventory)chest, rand, CHEST_LOOT, 8, 14);
        }
        world.func_180501_a(pos.func_177982_a(-1, 1, 1), ModBlocks.DUNG_SPAWNER_BOT_FLY.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(1, 1, 1), ModBlocks.DUNG_SPAWNER_FLY.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(1, 1, -1), ModBlocks.DUNG_SPAWNER_BOT_FLY.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(-1, 1, -1), ModBlocks.DUNG_SPAWNER_FLY.func_176223_P(), 2);
        world.func_180501_a(pos.func_177982_a(0, this.height, 0), ModBlocks.DUNG_SPAWNER_FLY.func_176223_P(), 2);
        return true;
    }

    private boolean aircheck(World world, Random rand, BlockPos pos) {
        for (int xx = -this.radius; xx <= this.radius; ++xx) {
            for (int zz = -this.radius; zz <= this.radius; ++zz) {
                if (!this.checkSurface(world, SurfaceType.MIXED, pos.func_177982_a(xx, -1, zz))) {
                    return false;
                }
                for (int yy = 0; yy < this.height; ++yy) {
                    if (world.func_175623_d(pos.func_177982_a(xx, yy, zz))) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected boolean checkSurface(World world, SurfaceType surfaceType, BlockPos pos) {
        return surfaceType.matchBlock(world.func_180495_p(pos));
    }
}

