/*
 * Decompiled with CFR 0.152.
 */
package erebus.world.feature.tree;

import erebus.blocks.EnumWood;
import erebus.world.feature.tree.WorldGenTreeBase;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class WorldGenAsperTree
extends WorldGenTreeBase {
    private static final int[] offsetX = new int[]{-1, 1, 0, 0};
    private static final int[] offsetZ = new int[]{0, 0, -1, 1};

    public WorldGenAsperTree() {
        super(EnumWood.ASPER);
    }

    public boolean func_180709_b(World world, Random rand, BlockPos pos) {
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        int height = rand.nextInt(2) + 4;
        if (y <= 0 || y + height > 255) {
            return false;
        }
        for (int testY = y + 1; testY <= y + height + 1; ++testY) {
            for (int testX = x - 2; testX <= x + 2; ++testX) {
                for (int testZ = z - 2; testZ <= z + 2; ++testZ) {
                    if (world.func_175623_d(new BlockPos(testX, testY, testZ))) continue;
                    return false;
                }
            }
        }
        if (world.func_180495_p(pos.func_177977_b()) != Blocks.field_150346_d.func_176223_P() && world.func_180495_p(pos.func_177977_b()) != Blocks.field_150349_c.func_176223_P()) {
            return false;
        }
        for (int yy = 0; yy < height; ++yy) {
            world.func_180501_a(new BlockPos(x, y + yy, z), this.log.func_176203_a(0), 2);
            if (yy == height - 1) continue;
            int extraWood = 0;
            for (int extraWoodAttempt = 0; extraWoodAttempt < 5 && extraWood < 3; ++extraWoodAttempt) {
                int dir = rand.nextInt(4);
                if (yy > 0 && !world.func_175623_d(new BlockPos(x + offsetX[dir], y + yy - 1, z + offsetZ[dir]))) continue;
                world.func_180501_a(new BlockPos(x + offsetX[dir], y + yy, z + offsetZ[dir]), this.log.func_176203_a(dir < 2 ? 4 : 8), 3);
                if (yy > 0 && rand.nextBoolean()) {
                    world.func_180501_a(new BlockPos(x + offsetX[dir] * 2, y + yy, z + offsetZ[dir] * 2), this.leaves, 2);
                }
                ++extraWood;
            }
        }
        double centerY = 2.0 + ((double)height - 2.0) * 0.5;
        for (int yy = 1; yy < height; ++yy) {
            for (int xx = -1; xx <= 1; ++xx) {
                for (int zz = -1; zz <= 1; ++zz) {
                    double dist;
                    if (xx == 0 && zz == 0 || !((dist = Math.sqrt((double)(xx * xx) + Math.pow(centerY - (double)yy, 2.0) + (double)(zz * zz))) <= 1.5) && !(rand.nextDouble() > dist - 1.5) || !world.func_175623_d(new BlockPos(x + xx, y + yy, z + zz))) continue;
                    world.func_180501_a(new BlockPos(x + xx, y + yy, z + zz), this.leaves, 2);
                }
            }
        }
        for (int a = 0; a < 4; ++a) {
            world.func_180501_a(new BlockPos(x + offsetX[a], y + height, z + offsetZ[a]), this.leaves, 2);
        }
        world.func_180501_a(new BlockPos(x, y + height, z), this.leaves, 2);
        return true;
    }
}

