/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.world;

import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import vazkii.quark.decoration.feature.BlazeLantern;
import vazkii.quark.world.feature.NetherObsidianSpikes;

public class ObsidianSpikeGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        if (world.field_73011_w.func_177495_o() && (double)random.nextFloat() < NetherObsidianSpikes.chunkChance) {
            block0: for (int i = 0; i < NetherObsidianSpikes.triesPerChunk; ++i) {
                int x = chunkX * 16 + random.nextInt(16) + 8;
                int z = chunkZ * 16 + random.nextInt(16) + 8;
                BlockPos pos = new BlockPos(x, 50, z);
                while (pos.func_177956_o() > 10) {
                    IBlockState state = world.func_180495_p(pos);
                    if (state.func_177230_c() == Blocks.field_150353_l) {
                        ObsidianSpikeGenerator.placeSpikeAt(world, pos);
                        continue block0;
                    }
                    pos = pos.func_177977_b();
                }
            }
        }
    }

    public static void placeSpikeAt(World world, BlockPos pos) {
        int i;
        int heightBelow = 10;
        int heightBottom = 3 + world.field_73012_v.nextInt(3);
        int heightMiddle = 2 + world.field_73012_v.nextInt(4);
        int heightTop = 2 + world.field_73012_v.nextInt(3);
        boolean addSpawner = false;
        if ((double)world.field_73012_v.nextFloat() < NetherObsidianSpikes.bigSpikeChance) {
            heightBottom += 7;
            heightMiddle += 8;
            heightTop += 4;
            addSpawner = NetherObsidianSpikes.bigSpikeSpawners;
        }
        int checkHeight = heightBottom + heightMiddle + heightTop + 2;
        for (int i2 = 0; i2 < 5; ++i2) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < checkHeight; ++k) {
                    BlockPos checkPos = pos.func_177982_a(i2 - 2, k, j - 2);
                    if (world.func_175623_d(checkPos) || world.func_180495_p(checkPos).func_185904_a() == Material.field_151587_i) continue;
                    return;
                }
            }
        }
        IBlockState obsidian = Blocks.field_150343_Z.func_176223_P();
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                for (int k = 0; k < heightBottom + heightBelow; ++k) {
                    BlockPos placePos = pos.func_177982_a(i - 1, k - heightBelow, j - 1);
                    if (world.func_180495_p(placePos).func_185887_b(world, placePos) == -1.0f) continue;
                    world.func_175656_a(placePos, obsidian);
                }
            }
        }
        for (i = 0; i < heightMiddle; ++i) {
            BlockPos placePos = pos.func_177982_a(0, heightBottom + i, 0);
            world.func_175656_a(placePos, obsidian);
            for (EnumFacing face : EnumFacing.field_176754_o) {
                world.func_175656_a(placePos.func_177972_a(face), obsidian);
            }
        }
        for (i = 0; i < heightTop; ++i) {
            BlockPos placePos = pos.func_177982_a(0, heightBottom + heightMiddle + i, 0);
            world.func_175656_a(placePos, obsidian);
            if (!addSpawner || i != 0) continue;
            world.func_175656_a(placePos, BlazeLantern.blaze_lantern == null ? Blocks.field_150426_aN.func_176223_P() : BlazeLantern.blaze_lantern.func_176223_P());
            placePos = placePos.func_177977_b();
            world.func_175656_a(placePos, Blocks.field_150474_ac.func_176223_P());
            ((TileEntityMobSpawner)world.func_175625_s(placePos)).func_145881_a().func_190894_a(new ResourceLocation("minecraft", "blaze"));
            placePos = placePos.func_177977_b();
            world.func_175656_a(placePos, Blocks.field_150486_ae.func_176223_P());
            ((TileEntityChest)world.func_175625_s(placePos)).func_189404_a(new ResourceLocation("minecraft", "chests/nether_bridge"), world.field_73012_v.nextLong());
        }
    }
}

