/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.gui;

import com.google.common.collect.LinkedListMultimap;
import forestry.apiculture.gui.ContainerHabitatLocator;
import forestry.apiculture.gui.HabitatSlot;
import forestry.apiculture.inventory.ItemInventoryHabitatLocator;
import forestry.core.gui.GuiForestry;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class GuiHabitatLocator
extends GuiForestry<ContainerHabitatLocator> {
    private static final LinkedListMultimap<String, BiomeDictionary.Type> habitats = LinkedListMultimap.create();
    private final ItemInventoryHabitatLocator itemInventory;
    private final List<HabitatSlot> habitatSlots = new ArrayList<HabitatSlot>(habitats.size());
    private int startX;
    private int startY;

    public GuiHabitatLocator(EntityPlayer player, ItemInventoryHabitatLocator itemInventory) {
        super("textures/gui/biomefinder.png", new ContainerHabitatLocator(player, itemInventory));
        this.itemInventory = itemInventory;
        this.field_146999_f = 176;
        this.field_147000_g = 184;
        int slot = 0;
        for (String habitatName : habitats.keySet()) {
            int y;
            int x;
            if (slot > 5) {
                x = 18 + (slot - 6) * 20;
                y = 50;
            } else {
                x = 18 + slot * 20;
                y = 32;
            }
            List biomes = habitats.get((Object)habitatName);
            HabitatSlot habitatSlot = new HabitatSlot(this.widgetManager, x, y, habitatName, biomes);
            this.habitatSlots.add(habitatSlot);
            this.widgetManager.add(habitatSlot);
            ++slot;
        }
    }

    @Override
    protected void func_146976_a(float var1, int mouseX, int mouseY) {
        super.func_146976_a(var1, mouseX, mouseY);
        String str = Translator.translateToLocal("item.for.habitat_locator.name").toUpperCase(Locale.ENGLISH);
        this.field_146289_q.func_78276_b(str, this.startX + 8 + this.textLayout.getCenteredOffset(str, 138), this.startY + 16, ColourProperties.INSTANCE.get("gui.screen"));
        HashSet<BiomeDictionary.Type> activeBiomeTypes = new HashSet<BiomeDictionary.Type>();
        for (Biome biome : this.itemInventory.getBiomesToSearch()) {
            Set biomeTypes = BiomeDictionary.getTypes((Biome)biome);
            activeBiomeTypes.addAll(biomeTypes);
        }
        for (HabitatSlot habitatSlot : this.habitatSlots) {
            habitatSlot.setActive(activeBiomeTypes);
        }
        for (HabitatSlot slot : this.habitatSlots) {
            slot.draw(this.startX, this.startY);
        }
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.startX = (this.field_146294_l - this.field_146999_f) / 2;
        this.startY = (this.field_146295_m - this.field_147000_g) / 2;
    }

    @Override
    protected void addLedgers() {
        this.addErrorLedger(this.itemInventory);
        this.addHintLedger("habitat.locator");
    }

    static {
        habitats.putAll((Object)"Ocean", Arrays.asList(BiomeDictionary.Type.OCEAN, BiomeDictionary.Type.BEACH));
        habitats.put((Object)"Plains", (Object)BiomeDictionary.Type.PLAINS);
        habitats.put((Object)"Desert", (Object)BiomeDictionary.Type.SANDY);
        habitats.putAll((Object)"Forest", Arrays.asList(BiomeDictionary.Type.FOREST, BiomeDictionary.Type.RIVER));
        habitats.put((Object)"Jungle", (Object)BiomeDictionary.Type.JUNGLE);
        habitats.put((Object)"Taiga", (Object)BiomeDictionary.Type.CONIFEROUS);
        habitats.put((Object)"Hills", (Object)BiomeDictionary.Type.MOUNTAIN);
        habitats.put((Object)"Swamp", (Object)BiomeDictionary.Type.SWAMP);
        habitats.put((Object)"Snow", (Object)BiomeDictionary.Type.SNOWY);
        habitats.put((Object)"Mushroom", (Object)BiomeDictionary.Type.MUSHROOM);
        habitats.put((Object)"Nether", (Object)BiomeDictionary.Type.NETHER);
        habitats.put((Object)"End", (Object)BiomeDictionary.Type.END);
    }
}

