/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.core.IItemModelRegister;
import forestry.api.core.IStateMapperRegister;
import forestry.arboriculture.IWoodTyped;
import forestry.arboriculture.blocks.BlockForestrySlab;
import forestry.arboriculture.blocks.PropertyVanillaWoodType;
import java.util.ArrayList;
import java.util.List;

public abstract class BlockFireproofVanillaSlab
extends BlockForestrySlab<EnumVanillaWoodType>
implements IWoodTyped,
IItemModelRegister,
IStateMapperRegister {
    public static List<BlockFireproofVanillaSlab> create(final boolean doubleSlab) {
        ArrayList<BlockFireproofVanillaSlab> blocks = new ArrayList<BlockFireproofVanillaSlab>();
        PropertyVanillaWoodType[] variants = PropertyVanillaWoodType.create("variant", 8);
        for (int i = 0; i < variants.length; ++i) {
            final PropertyVanillaWoodType variant = variants[i];
            BlockFireproofVanillaSlab block = new BlockFireproofVanillaSlab(i){

                public PropertyVanillaWoodType getVariant() {
                    return variant;
                }

                public boolean func_176552_j() {
                    return doubleSlab;
                }
            };
            blocks.add(block);
        }
        return blocks;
    }

    private BlockFireproofVanillaSlab(int blockNumber) {
        super(true, blockNumber);
    }

    @Override
    public EnumVanillaWoodType getWoodType(int meta) {
        int variantCount = this.getVariant().func_177700_c().size();
        int variantMeta = (meta &= 0xFFFFFFF7) % variantCount + this.getBlockNumber() * 8;
        return EnumVanillaWoodType.byMetadata(variantMeta);
    }
}

