/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.blocks;

import com.google.common.base.Optional;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.core.blocks.properties.PropertyAllele;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class PropertyTree
extends PropertyAllele<IAlleleTreeSpecies> {
    private static final Map<String, IAlleleTreeSpecies> namesMap = new HashMap<String, IAlleleTreeSpecies>();

    public PropertyTree(String name) {
        super(name);
    }

    public Class<IAlleleTreeSpecies> func_177699_b() {
        return IAlleleTreeSpecies.class;
    }

    @Override
    public List<IAlleleTreeSpecies> getAllowedValues() {
        ArrayList<IAlleleTreeSpecies> trees = new ArrayList<IAlleleTreeSpecies>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleTreeSpecies)) continue;
            trees.add((IAlleleTreeSpecies)allele);
        }
        return trees;
    }

    public String getName(IAlleleTreeSpecies value) {
        return value.getUID().replace("forestry.tree", "").toLowerCase(Locale.ENGLISH);
    }

    @Override
    public Optional<IAlleleTreeSpecies> func_185929_b(String value) {
        if (namesMap.isEmpty()) {
            List<IAlleleTreeSpecies> allowedValues = this.getAllowedValues();
            for (IAlleleTreeSpecies allowedValue : allowedValues) {
                String propertyName = this.getName(allowedValue);
                namesMap.put(propertyName, allowedValue);
            }
        }
        return Optional.fromNullable((Object)namesMap.get(value));
    }
}

