/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.commands;

import forestry.api.arboriculture.ITreekeepingMode;
import forestry.api.arboriculture.TreeManager;
import forestry.core.commands.ICommandModeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.World;

public class TreeModeHelper
implements ICommandModeHelper {
    @Override
    public String[] getModeNames() {
        List<ITreekeepingMode> treekeepingModes = TreeManager.treeRoot.getTreekeepingModes();
        int modeStringCount = treekeepingModes.size();
        ArrayList<String> modeStrings = new ArrayList<String>(modeStringCount);
        for (ITreekeepingMode mode : treekeepingModes) {
            modeStrings.add(mode.getName());
        }
        return modeStrings.toArray(new String[modeStringCount]);
    }

    @Override
    public String getModeName(World world) {
        return TreeManager.treeRoot.getTreekeepingMode(world).getName();
    }

    @Override
    public boolean setMode(World world, String modeName) {
        ITreekeepingMode mode = TreeManager.treeRoot.getTreekeepingMode(modeName);
        if (mode != null) {
            TreeManager.treeRoot.setTreekeepingMode(world, mode);
            return true;
        }
        return false;
    }

    @Override
    public Iterable<String> getDescription(String modeName) {
        ITreekeepingMode mode = TreeManager.treeRoot.getTreekeepingMode(modeName);
        if (mode == null) {
            return Collections.emptyList();
        }
        return mode.getDescription();
    }
}

