/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture.genetics;

import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.arboriculture.tiles.TileSapling;
import forestry.core.tiles.TileUtil;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TreeGrowthHelper {
    @Nullable
    public static BlockPos canGrow(World world, ITreeGenome genome, BlockPos pos, int expectedGirth, int expectedHeight) {
        BlockPos growthPos = TreeGrowthHelper.hasSufficientSaplingsAroundSapling(genome, world, pos, expectedGirth);
        if (growthPos == null) {
            return null;
        }
        if (!TreeGrowthHelper.hasRoom(world, growthPos, expectedGirth, expectedHeight)) {
            return null;
        }
        return growthPos;
    }

    private static boolean hasRoom(World world, BlockPos pos, int expectedGirth, int expectedHeight) {
        Vec3i area = new Vec3i(expectedGirth, expectedHeight + 1, expectedGirth);
        return TreeGrowthHelper.checkArea(world, pos.func_177984_a(), area);
    }

    private static boolean checkArea(World world, BlockPos start, Vec3i area) {
        for (int x = 0; x < area.func_177958_n(); ++x) {
            for (int y = 0; y < area.func_177956_o(); ++y) {
                for (int z = 0; z < area.func_177952_p(); ++z) {
                    BlockPos pos = start.func_177982_a(x, y, z);
                    IBlockState blockState = world.func_180495_p(pos);
                    if (blockState.func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    @Nullable
    private static BlockPos hasSufficientSaplingsAroundSapling(ITreeGenome genome, World world, BlockPos saplingPos, int expectedGirth) {
        int checkSize = expectedGirth * 2 - 1;
        int offset = expectedGirth - 1;
        HashMap<BlockPos, Boolean> knownSaplings = new HashMap<BlockPos, Boolean>(checkSize * checkSize);
        for (int x = -offset; x <= 0; ++x) {
            for (int z = -offset; z <= 0; ++z) {
                BlockPos startPos = saplingPos.func_177982_a(x, 0, z);
                if (!TreeGrowthHelper.checkForSaplings(genome, world, startPos, expectedGirth, knownSaplings)) continue;
                return startPos;
            }
        }
        return null;
    }

    private static boolean checkForSaplings(ITreeGenome genome, World world, BlockPos startPos, int girth, Map<BlockPos, Boolean> knownSaplings) {
        for (int x = 0; x < girth; ++x) {
            for (int z = 0; z < girth; ++z) {
                BlockPos checkPos = startPos.func_177982_a(x, 0, z);
                Boolean knownSapling = knownSaplings.computeIfAbsent(checkPos, k -> TreeGrowthHelper.isSapling(genome, world, checkPos));
                if (knownSapling.booleanValue()) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isSapling(ITreeGenome genome, World world, BlockPos pos) {
        if (!world.func_175667_e(pos)) {
            return false;
        }
        if (world.func_175623_d(pos)) {
            return false;
        }
        TileSapling sapling = TileUtil.getTile((IBlockAccess)world, pos, TileSapling.class);
        if (sapling == null) {
            return false;
        }
        ITree tree = sapling.getTree();
        return tree != null && tree.getGenome().getPrimary().getUID().equals(genome.getPrimary().getUID());
    }
}

