/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.models;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import forestry.core.models.ModelBlockCustom;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class ModelBlockCustomCached<B extends Block, K>
extends ModelBlockCustom<B, K> {
    private static final Set<ModelBlockCustomCached> CACHE_PROVIDERS = new HashSet<ModelBlockCustomCached>();
    private final Cache<K, IBakedModel> inventoryCache;
    private final Cache<K, IBakedModel> worldCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();

    public static void clear() {
        for (ModelBlockCustomCached modelBlockCached : CACHE_PROVIDERS) {
            modelBlockCached.worldCache.invalidateAll();
            modelBlockCached.inventoryCache.invalidateAll();
            modelBlockCached.onClearCaches();
        }
    }

    protected void onClearCaches() {
    }

    protected ModelBlockCustomCached(Class<B> blockClass) {
        super(blockClass);
        this.inventoryCache = CacheBuilder.newBuilder().expireAfterAccess(1L, TimeUnit.MINUTES).build();
        CACHE_PROVIDERS.add(this);
    }

    @Override
    protected IBakedModel getModel(IBlockState state) {
        Object key = this.getWorldKey(state);
        IBakedModel model = (IBakedModel)this.worldCache.getIfPresent(key);
        if (model == null) {
            model = super.getModel(state);
            this.worldCache.put(key, (Object)model);
        }
        return model;
    }

    @Override
    protected IBakedModel getModel(ItemStack stack, World world) {
        Object key = this.getInventoryKey(stack);
        IBakedModel model = (IBakedModel)this.inventoryCache.getIfPresent(key);
        if (model == null) {
            model = this.bakeModel(stack, world, key);
            this.inventoryCache.put(key, (Object)model);
        }
        return model;
    }
}

