/*
 * Decompiled with CFR 0.152.
 */
package forestry.factory.tiles;

import com.google.common.base.Preconditions;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IStillRecipe;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.TankManager;
import forestry.core.network.PacketBufferForestry;
import forestry.core.render.TankRenderInfo;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.factory.gui.ContainerStill;
import forestry.factory.gui.GuiStill;
import forestry.factory.inventory.InventoryStill;
import forestry.factory.recipes.StillRecipeManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileStill
extends TilePowered
implements ISidedInventory,
ILiquidTankTile {
    private static final int ENERGY_PER_RECIPE_TIME = 200;
    private final FilteredTank resourceTank;
    private final FilteredTank productTank;
    private final TankManager tankManager;
    @Nullable
    private IStillRecipe currentRecipe;
    @Nullable
    private FluidStack bufferedLiquid;

    public TileStill() {
        super(1100, 8000);
        this.setInternalInventory(new InventoryStill(this));
        this.resourceTank = new FilteredTank(10000, true, false);
        this.resourceTank.setFilters(StillRecipeManager.recipeFluidInputs);
        this.productTank = new FilteredTank(10000, false, true);
        this.productTank.setFilters(StillRecipeManager.recipeFluidOutputs);
        this.tankManager = new TankManager(this, this.resourceTank, this.productTank);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.tankManager.writeToNBT(nbttagcompound);
        if (this.bufferedLiquid != null) {
            NBTTagCompound buffer = new NBTTagCompound();
            this.bufferedLiquid.writeToNBT(buffer);
            nbttagcompound.func_74782_a("Buffer", (NBTBase)buffer);
        }
        return nbttagcompound;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.tankManager.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("Buffer")) {
            NBTTagCompound buffer = nbttagcompound.func_74775_l("Buffer");
            this.bufferedLiquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)buffer);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
    }

    @Override
    public void updateServerSide() {
        super.updateServerSide();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 2);
            FluidStack fluidStack = this.productTank.getFluid();
            if (fluidStack != null) {
                FluidHelper.fillContainers(this.tankManager, (IInventory)this, 1, 0, fluidStack.getFluid(), true);
            }
        }
    }

    @Override
    public boolean workCycle() {
        Preconditions.checkNotNull((Object)this.currentRecipe);
        int cycles = this.currentRecipe.getCyclesPerUnit();
        FluidStack output = this.currentRecipe.getOutput();
        FluidStack product = new FluidStack(output, output.amount * cycles);
        this.productTank.fillInternal(product, true);
        this.bufferedLiquid = null;
        return true;
    }

    private void checkRecipe() {
        FluidStack recipeLiquid;
        FluidStack fluidStack = recipeLiquid = this.bufferedLiquid != null ? this.bufferedLiquid : this.resourceTank.getFluid();
        if (!StillRecipeManager.matches(this.currentRecipe, recipeLiquid)) {
            this.currentRecipe = StillRecipeManager.findMatchingRecipe(recipeLiquid);
            int recipeTime = this.currentRecipe == null ? 0 : this.currentRecipe.getCyclesPerUnit();
            this.setEnergyPerWorkCycle(200 * recipeTime);
            this.setTicksPerWorkCycle(recipeTime);
        }
    }

    @Override
    public boolean hasWork() {
        this.checkRecipe();
        boolean hasRecipe = this.currentRecipe != null;
        boolean hasTankSpace = true;
        boolean hasLiquidResource = true;
        if (hasRecipe) {
            FluidStack fluidStack = this.currentRecipe.getOutput();
            boolean bl = hasTankSpace = this.productTank.fillInternal(fluidStack, false) == fluidStack.amount;
            if (this.bufferedLiquid == null) {
                int cycles = this.currentRecipe.getCyclesPerUnit();
                FluidStack input = this.currentRecipe.getInput();
                int drainAmount = cycles * input.amount;
                FluidStack drained = this.resourceTank.drain(drainAmount, false);
                boolean bl2 = hasLiquidResource = drained != null && drained.amount == drainAmount;
                if (hasLiquidResource) {
                    this.bufferedLiquid = new FluidStack(input, drainAmount);
                    this.resourceTank.drain(drainAmount, true);
                }
            }
        }
        IErrorLogic errorLogic = this.getErrorLogic();
        errorLogic.setCondition(!hasRecipe, EnumErrorCode.NO_RECIPE);
        errorLogic.setCondition(!hasTankSpace, EnumErrorCode.NO_SPACE_TANK);
        errorLogic.setCondition(!hasLiquidResource, EnumErrorCode.NO_RESOURCE_LIQUID);
        return hasRecipe && hasLiquidResource && hasTankSpace;
    }

    @Override
    public TankRenderInfo getResourceTankInfo() {
        return new TankRenderInfo((IFluidTank)this.resourceTank);
    }

    @Override
    public TankRenderInfo getProductTankInfo() {
        return new TankRenderInfo((IFluidTank)this.productTank);
    }

    @Override
    public TankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiStill(player.field_71071_by, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerStill(player.field_71071_by, this);
    }
}

