/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import forestry.api.farming.FarmDirection;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.api.farming.ISoil;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicSoil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class FarmLogicHomogeneous
extends FarmLogicSoil {
    protected NonNullList<ItemStack> produce = NonNullList.func_191196_a();

    public FarmLogicHomogeneous(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
    }

    @Override
    public boolean isAcceptedGermling(ItemStack itemstack) {
        for (IFarmable germling : this.getFarmables()) {
            if (!germling.isGermling(itemstack)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isAcceptedWindfall(ItemStack itemstack) {
        for (IFarmable germling : this.getFarmables()) {
            if (!germling.isWindfall(itemstack)) continue;
            return true;
        }
        return false;
    }

    protected boolean trySetCrop(World world, IFarmHousing farmHousing, BlockPos position, FarmDirection direction) {
        for (IFarmable candidate : this.getFarmables()) {
            if (!farmHousing.plantGermling(candidate, world, position, direction)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean cultivate(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        return this.maintainSoil(world, farmHousing, pos, direction, extent) || this.maintainGermlings(world, farmHousing, pos.func_177984_a(), direction, extent);
    }

    private boolean maintainSoil(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        if (!farmHousing.canPlantSoil(this.isManual)) {
            return false;
        }
        block0: for (ISoil soil : this.getSoils()) {
            NonNullList resources = NonNullList.func_191196_a();
            resources.add((Object)soil.getResource());
            if (!farmHousing.getFarmInventory().hasResources((NonNullList<ItemStack>)resources)) continue;
            for (int i = 0; i < extent; ++i) {
                BlockPos position = this.translateWithOffset(pos, direction, i);
                IBlockState soilState = world.func_180495_p(position);
                if (!world.func_175667_e(position) || farmHousing.isValidPlatform(world, pos)) continue block0;
                if (!BlockUtil.isBreakableBlock(soilState, world, pos) || this.isAcceptedSoil(soilState)) continue;
                BlockPos platformPosition = position.func_177977_b();
                if (!farmHousing.isValidPlatform(world, platformPosition)) continue block0;
                this.produce.addAll(BlockUtil.getBlockDrops(world, position));
                BlockUtil.setBlockWithPlaceSound(world, position, soil.getSoilState());
                farmHousing.getFarmInventory().removeResources((NonNullList<ItemStack>)resources);
                return true;
            }
        }
        return false;
    }

    protected abstract boolean maintainGermlings(World var1, IFarmHousing var2, BlockPos var3, FarmDirection var4, int var5);
}

