/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.base.Preconditions;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import forestry.api.storage.IBackpackFilterConfigurable;
import forestry.api.storage.IBackpackInterface;
import forestry.core.proxy.Proxies;
import forestry.core.utils.ItemStackUtil;
import forestry.storage.BackpackFilter;
import forestry.storage.BackpackFilterNaturalist;
import forestry.storage.items.ItemBackpack;
import forestry.storage.items.ItemBackpackNaturalist;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;

public class BackpackInterface
implements IBackpackInterface {
    private final Map<String, IBackpackDefinition> definitions = new HashMap<String, IBackpackDefinition>();
    private final Map<String, List<String>> backpackAcceptedItems = new HashMap<String, List<String>>();

    public Map<String, List<String>> getBackpackAcceptedItems() {
        return this.backpackAcceptedItems;
    }

    @Override
    public void addItemToForestryBackpack(String backpackUid, ItemStack itemStack) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)itemStack, (Object)"itemStack must not be null");
        Preconditions.checkArgument((!itemStack.func_190926_b() ? 1 : 0) != 0, (Object)"itemStack must not be empty");
        String stringForItemStack = ItemStackUtil.getStringForItemStack(itemStack);
        if (stringForItemStack != null) {
            List acceptedItems = this.backpackAcceptedItems.computeIfAbsent(backpackUid, k -> NonNullList.func_191196_a());
            acceptedItems.add(stringForItemStack);
        }
    }

    @Override
    public void registerBackpackDefinition(String backpackUid, IBackpackDefinition definition) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)definition, (Object)"definition must not be null");
        this.definitions.put(backpackUid, definition);
    }

    @Override
    @Nullable
    public IBackpackDefinition getBackpackDefinition(String backpackUid) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        return this.definitions.get(backpackUid);
    }

    @Override
    public Item createBackpack(String backpackUid, EnumBackpackType type) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)((Object)type), (Object)"type must not be null");
        Preconditions.checkArgument((type != EnumBackpackType.NATURALIST ? 1 : 0) != 0, (Object)"type must not be NATURALIST. Use createNaturalistBackpack instead.");
        IBackpackDefinition definition = this.definitions.get(backpackUid);
        if (definition == null) {
            throw new IllegalArgumentException("No backpack definition was registered for UID: " + backpackUid);
        }
        ItemBackpack backpack = new ItemBackpack(definition, type);
        Proxies.common.registerItem(backpack);
        return backpack;
    }

    @Override
    public Item createNaturalistBackpack(String backpackUid, ISpeciesRoot speciesRoot) {
        Preconditions.checkNotNull((Object)backpackUid, (Object)"backpackUid must not be null");
        Preconditions.checkNotNull((Object)speciesRoot, (Object)"speciesRoot must not be null");
        IBackpackDefinition definition = this.definitions.get(backpackUid);
        if (definition == null) {
            throw new IllegalArgumentException("No backpack definition was registered for UID: " + backpackUid);
        }
        ItemBackpackNaturalist backpack = new ItemBackpackNaturalist(speciesRoot, definition);
        Proxies.common.registerItem(backpack);
        return backpack;
    }

    @Override
    public IBackpackFilterConfigurable createBackpackFilter() {
        return new BackpackFilter();
    }

    @Override
    public Predicate<ItemStack> createNaturalistBackpackFilter(String speciesRootUid) {
        return new BackpackFilterNaturalist(speciesRootUid);
    }
}

