/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.distribution;

import cofh.cofhworld.parser.IDistributionParser;
import cofh.cofhworld.parser.variables.BlockData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.IConfigurableFeatureGenerator;
import cofh.cofhworld.world.distribution.DistributionReplace;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.Logger;

public class DistParserReplace
implements IDistributionParser {
    private final String[] FIELDS = new String[]{"block", "replacement"};

    @Override
    public String[] getRequiredFields() {
        return this.FIELDS;
    }

    @Override
    @Nonnull
    public IConfigurableFeatureGenerator getFeature(String featureName, Config genObject, boolean retrogen, Logger log) throws IDistributionParser.InvalidDistributionException {
        ArrayList<WeightedBlock> blockstates = new ArrayList<WeightedBlock>();
        if (!BlockData.parseBlockList(genObject.root().get("block"), blockstates, true)) {
            throw new IDistributionParser.InvalidDistributionException("`block` not valid", genObject.origin());
        }
        ArrayList<WeightedBlock> replacement = new ArrayList<WeightedBlock>();
        if (!BlockData.parseBlockList(genObject.root().get("replacement"), replacement, false)) {
            throw new IDistributionParser.InvalidDistributionException("`replacement` not valid", genObject.origin());
        }
        return new DistributionReplace(featureName, retrogen, blockstates, replacement);
    }
}

