/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.attributefix;

import java.io.File;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.common.config.Configuration;
import org.apache.commons.lang3.StringUtils;

public class ConfigurationHandler {
    public static Configuration config;

    public ConfigurationHandler(File file) {
        config = new Configuration(file);
    }

    public void configureRangedAttribute(RangedAttribute attribute) {
        String name = StringUtils.capitalize((String)attribute.func_111108_a().replace("generic.", ""));
        attribute.field_111118_b = config.getFloat("max" + name, "attributes", this.getAdjustedAmount((float)attribute.field_111118_b), Float.MIN_VALUE, Float.MAX_VALUE, "The maximum amount for the " + name + " attribute.");
        attribute.field_111120_a = config.getFloat("min" + name, "attributes", (float)attribute.field_111120_a, Float.MIN_VALUE, Float.MAX_VALUE, "The minimum amount for the " + name + " attribute.");
        if (attribute.field_111120_a > attribute.field_111118_b) {
            throw new IllegalArgumentException("The " + name + " attribute was configured incorrectly! Minimum must not be greater than maximum!");
        }
    }

    private float getAdjustedAmount(float amount) {
        return Math.max(amount, 65536.0f);
    }

    public void syncConfigData() {
        if (config.hasChanged()) {
            config.save();
        }
    }
}

