/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.parsing.postfix;

import com.google.common.base.Preconditions;
import info.openmods.calc.parsing.postfix.IExecutableListBuilder;
import info.openmods.calc.parsing.postfix.IPostfixParserState;
import info.openmods.calc.parsing.postfix.SimplePostfixParserState;
import info.openmods.calc.parsing.token.Token;
import info.openmods.calc.parsing.token.TokenType;
import info.openmods.calc.parsing.token.TokenUtils;

public abstract class BracketPostfixParserStateBase<E>
extends SimplePostfixParserState<E> {
    private final String openingBracket;
    private boolean isFinished;

    public BracketPostfixParserStateBase(IExecutableListBuilder<E> builder, String openingBracket) {
        super(builder);
        this.openingBracket = openingBracket;
    }

    @Override
    public IPostfixParserState.Result acceptToken(Token token) {
        if (token.type == TokenType.RIGHT_BRACKET) {
            TokenUtils.checkIsValidBracketPair(this.openingBracket, token.value);
            this.isFinished = true;
            return IPostfixParserState.Result.ACCEPTED_AND_FINISHED;
        }
        return this.processBracketContent(token);
    }

    protected IPostfixParserState.Result processBracketContent(Token token) {
        return super.acceptToken(token);
    }

    @Override
    public E getResult() {
        Preconditions.checkState((boolean)this.isFinished, (Object)"Missing closing bracket");
        Object compiledExpr = super.getResult();
        return this.processCompiledBracket(compiledExpr);
    }

    protected abstract E processCompiledBracket(E var1);
}

