/*
 * Decompiled with CFR 0.152.
 */
package info.openmods.calc.types.multi;

import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import info.openmods.calc.Frame;
import info.openmods.calc.symbol.ICallable;
import info.openmods.calc.symbol.UnaryFunction;
import info.openmods.calc.types.multi.CallableValue;
import info.openmods.calc.types.multi.Cons;
import info.openmods.calc.types.multi.MetaObject;
import info.openmods.calc.types.multi.MetaObjectUtils;
import info.openmods.calc.types.multi.SimpleTypedFunction;
import info.openmods.calc.types.multi.TypeDomain;
import info.openmods.calc.types.multi.TypedFunction;
import info.openmods.calc.types.multi.TypedValue;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class StringAttrs {
    private final Map<String, StringAttr> attrs = Maps.newHashMap();
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");

    public StringAttrs(final TypedValue nullValue) {
        this.attrs.put("lower", new StringAttr(){

            @Override
            public TypedValue get(TypeDomain domain, String value) {
                return domain.create(String.class, value.toLowerCase(Locale.ROOT));
            }
        });
        this.attrs.put("upper", new StringAttr(){

            @Override
            public TypedValue get(TypeDomain domain, String value) {
                return domain.create(String.class, value.toUpperCase(Locale.ROOT));
            }
        });
        this.attrs.put("strip", new StringAttr(){

            @Override
            public TypedValue get(TypeDomain domain, String value) {
                return domain.create(String.class, StringUtils.strip((String)value));
            }
        });
        this.attrs.put("startsWith", new StringAttr(){

            @Override
            public TypedValue get(final TypeDomain domain, final String value) {
                return CallableValue.wrap(domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                    @Override
                    protected TypedValue call(TypedValue prefix) {
                        boolean result = value.startsWith(prefix.as(String.class));
                        return domain.create(Boolean.class, result);
                    }
                });
            }
        });
        this.attrs.put("endsWith", new StringAttr(){

            @Override
            public TypedValue get(final TypeDomain domain, final String value) {
                return CallableValue.wrap(domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                    @Override
                    protected TypedValue call(TypedValue prefix) {
                        boolean result = value.endsWith(prefix.as(String.class));
                        return domain.create(Boolean.class, result);
                    }
                });
            }
        });
        this.attrs.put("indexOf", new StringAttr(){

            @Override
            public TypedValue get(final TypeDomain domain, final String value) {
                return CallableValue.wrap(domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                    @Override
                    protected TypedValue call(TypedValue prefix) {
                        int result = value.indexOf(prefix.as(String.class));
                        return domain.create(BigInteger.class, BigInteger.valueOf(result));
                    }
                });
            }
        });
        this.attrs.put("split", new StringAttr(){

            @Override
            public TypedValue get(TypeDomain domain, final String value) {
                return CallableValue.wrap(domain, new SimpleTypedFunction(domain){

                    @TypedFunction.Variant
                    @TypedFunction.RawReturn
                    public TypedValue split() {
                        Iterable result = Splitter.on((Pattern)WHITESPACE).split((CharSequence)value);
                        return StringAttrs.toList(nullValue, result);
                    }

                    @TypedFunction.Variant
                    @TypedFunction.RawReturn
                    public TypedValue split(@TypedFunction.DispatchArg String separator) {
                        Iterable result = Splitter.on((String)separator).split((CharSequence)value);
                        return StringAttrs.toList(nullValue, result);
                    }

                    @TypedFunction.Variant
                    @TypedFunction.RawReturn
                    public TypedValue split(String separator, @TypedFunction.DispatchArg BigInteger maxSplit) {
                        Iterable result = Splitter.on((String)separator).limit(maxSplit.intValue()).split((CharSequence)value);
                        return StringAttrs.toList(nullValue, result);
                    }
                });
            }
        });
        this.attrs.put("join", new StringAttr(){

            @Override
            public TypedValue get(final TypeDomain domain, String value) {
                final Joiner joiner = Joiner.on((String)value);
                return CallableValue.wrap(domain, (ICallable<TypedValue>)new UnaryFunction.Direct<TypedValue>(){

                    @Override
                    protected TypedValue call(TypedValue list) {
                        String result = joiner.join(Iterables.transform(Cons.toIterable(list, nullValue), domain.createUnwrappingTransformer(String.class)));
                        return domain.create(String.class, result);
                    }
                });
            }
        });
        this.attrs.put("ord", new StringAttr(){

            @Override
            public TypedValue get(TypeDomain domain, String value) {
                Preconditions.checkArgument((value.codePointCount(0, value.length()) == 1 ? 1 : 0) != 0, (String)"Not a single character: '%s'", (Object)value);
                return domain.create(BigInteger.class, BigInteger.valueOf(value.codePointAt(0)));
            }
        });
        this.attrs.put("reverse", new StringAttr(){

            @Override
            public TypedValue get(TypeDomain domain, String value) {
                return domain.create(String.class, StringUtils.reverse((String)value));
            }
        });
    }

    private static TypedValue toList(TypedValue nullValue, Iterable<String> parts) {
        TypeDomain domain = nullValue.domain;
        ArrayList result = Lists.newArrayList();
        for (String part : parts) {
            result.add(domain.create(String.class, part));
        }
        return Cons.createList(result, nullValue);
    }

    public MetaObject.SlotAttr createAttrSlot() {
        return new MetaObject.SlotAttr(){

            @Override
            public Optional<TypedValue> attr(TypedValue self, String key, Frame<TypedValue> frame) {
                StringAttr attr = (StringAttr)StringAttrs.this.attrs.get(key);
                if (attr == null) {
                    return Optional.absent();
                }
                String value = self.as(String.class);
                return Optional.of((Object)attr.get(self.domain, value));
            }
        };
    }

    public MetaObject.SlotDir createDirSlot() {
        return MetaObjectUtils.dirFromIterable(this.attrs.keySet());
    }

    private static interface StringAttr {
        public TypedValue get(TypeDomain var1, String var2);
    }
}

