/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.block;

import it.zerono.mods.zerocore.api.multiblock.tier.IMultiblockDescriptorProvider;
import it.zerono.mods.zerocore.api.multiblock.tier.MultiblockDescriptor;
import it.zerono.mods.zerocore.lib.block.BlockMultiblockPart;
import it.zerono.mods.zerocore.lib.block.IMultiblockTieredPartType;
import it.zerono.mods.zerocore.lib.block.properties.IPropertyValue;
import it.zerono.mods.zerocore.lib.item.ItemMultiblockTieredPart;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;

public class BlockMultiblockTieredPart<Tier extends Enum<Tier>, PartType extends Enum<PartType>, Descriptor extends MultiblockDescriptor<Tier>>
extends BlockMultiblockPart<PartType>
implements IMultiblockDescriptorProvider {
    private List<ItemStack> _subBlocks;
    private static IMultiblockTieredPartType s_preDescriptorProvider;

    public BlockMultiblockTieredPart(@Nonnull PartType type, @Nonnull String blockName, @Nonnull Material material) {
        super(type, blockName, material);
        s_preDescriptorProvider = null;
    }

    public static void preInitDescriptorProvider(@Nonnull IMultiblockTieredPartType provider) {
        s_preDescriptorProvider = provider;
    }

    @Override
    @Nonnull
    public Descriptor getMultiblockDescriptor() {
        IMultiblockTieredPartType provider = null != this._partType ? (IMultiblockTieredPartType)((Object)this._partType) : s_preDescriptorProvider;
        MultiblockDescriptor descriptor = provider.getMultiblockDescriptor();
        return (Descriptor)descriptor;
    }

    @Override
    public void onRegisterItemBlocks(@Nonnull IForgeRegistry<Item> registry) {
        registry.register(new ItemMultiblockTieredPart(this).setRegistryName(this.getRegistryName()));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onRegisterModels() {
        Item item = Item.func_150898_a((Block)this);
        ResourceLocation location = this.getRegistryName();
        IBlockState defaultState = this.func_176223_P();
        StringBuilder sb = new StringBuilder(32);
        boolean first = true;
        for (IProperty prop : defaultState.func_177228_b().keySet()) {
            String name = prop.func_177701_a();
            if (!first) {
                sb.append(',');
            }
            if ("tier".equals(name)) {
                sb.append("tier=%s");
            } else {
                sb.append(name);
                sb.append('=');
                sb.append(defaultState.func_177229_b(prop));
            }
            first = false;
        }
        String mapFormat = sb.toString();
        EnumSet activeTiers = ((MultiblockDescriptor)this.getMultiblockDescriptor()).getActiveTiers();
        for (Enum tier : activeTiers) {
            ModelLoader.setCustomModelResourceLocation((Item)item, (int)((IPropertyValue)((Object)tier)).toMeta(), (ModelResourceLocation)new ModelResourceLocation(location, String.format(mapFormat, ((IStringSerializable)tier).func_176610_l())));
        }
    }

    @Nonnull
    public Tier getTierFromState(@Nonnull IBlockState state) {
        return (Tier)((Enum)((Object)state.func_177229_b(((MultiblockDescriptor)this.getMultiblockDescriptor()).getTierProperty())));
    }

    @Override
    public int func_176201_c(IBlockState state) {
        return ((IPropertyValue)((Object)((Enum)((Object)state.func_177229_b(((MultiblockDescriptor)this.getMultiblockDescriptor()).getTierProperty()))))).toMeta();
    }

    public IBlockState func_176203_a(int meta) {
        Descriptor descriptor = this.getMultiblockDescriptor();
        return super.func_176203_a(meta).func_177226_a(((MultiblockDescriptor)descriptor).getTierProperty(), ((MultiblockDescriptor)descriptor).getTierFromMeta(meta));
    }

    public int func_180651_a(IBlockState state) {
        return ((IPropertyValue)((Object)((Enum)((Object)state.func_177229_b(((MultiblockDescriptor)this.getMultiblockDescriptor()).getTierProperty()))))).toMeta();
    }

    @Nonnull
    public ItemStack createItemStack(@Nonnull Tier tier, int amount) {
        return new ItemStack((Block)this, amount, ((IPropertyValue)tier).toMeta());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (null == this._subBlocks) {
            EnumSet tiers = ((MultiblockDescriptor)this.getMultiblockDescriptor()).getActiveTiers();
            this._subBlocks = new ArrayList<ItemStack>();
            for (Enum tier : tiers) {
                this._subBlocks.add(this.createItemStack(tier, 1));
            }
        }
        list.addAll(this._subBlocks);
    }

    @Override
    protected void buildBlockState(@Nonnull BlockStateContainer.Builder builder) {
        super.buildBlockState(builder);
        builder.add(new IProperty[]{((MultiblockDescriptor)this.getMultiblockDescriptor()).getTierProperty()});
    }

    @Override
    @Nonnull
    protected IBlockState buildDefaultState(@Nonnull IBlockState state) {
        Descriptor descriptor = this.getMultiblockDescriptor();
        return super.buildDefaultState(state).func_177226_a(((MultiblockDescriptor)descriptor).getTierProperty(), ((MultiblockDescriptor)descriptor).getDefaultTier());
    }
}

