/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.math;

import javax.annotation.Nonnull;

public class LightMap {
    public int SKY_LIGHT;
    public int BLOCK_LIGHT;

    public LightMap(int skyLight, int blockLight) {
        this.set(skyLight, blockLight);
    }

    public LightMap(@Nonnull LightMap other) {
        this.set(other);
    }

    @Nonnull
    public static LightMap fromCombinedLight(int combinedLight) {
        return new LightMap(LightMap.getSkyLightFromCombined(combinedLight), LightMap.getBlockLightFromCombined(combinedLight));
    }

    public static int getSkyLightFromCombined(int combinedLight) {
        return combinedLight >> 16 & 0xFFFF;
    }

    public static int getBlockLightFromCombined(int combinedLight) {
        return combinedLight & 0xFFFF;
    }

    public static int getCombinedLight(int skyLight, int blockLight) {
        return skyLight << 20 | blockLight << 4;
    }

    @Nonnull
    public LightMap set(int skyLight, int blockLight) {
        this.SKY_LIGHT = skyLight;
        this.BLOCK_LIGHT = blockLight;
        return this;
    }

    @Nonnull
    public LightMap set(@Nonnull LightMap other) {
        return this.set(other.SKY_LIGHT, other.BLOCK_LIGHT);
    }

    @Nonnull
    public LightMap set(int combinedLight) {
        return this.set(LightMap.getSkyLightFromCombined(combinedLight), LightMap.getBlockLightFromCombined(combinedLight));
    }

    public boolean equals(Object other) {
        if (other instanceof LightMap) {
            LightMap map = (LightMap)other;
            return this.SKY_LIGHT == map.SKY_LIGHT && this.BLOCK_LIGHT == map.BLOCK_LIGHT;
        }
        return false;
    }

    public String toString() {
        return String.format("LightMap (0x%08x, 0x%08x)", this.SKY_LIGHT, this.BLOCK_LIGHT);
    }

    private LightMap() {
    }
}

