/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.crucible;

import exnihilocreatio.compatibility.jei.crucible.CrucibleRecipe;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.Meltable;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CrucibleRecipeCategory
implements IRecipeCategory<CrucibleRecipe> {
    public final String UID;
    private static final ResourceLocation texture = new ResourceLocation("exnihilocreatio", "textures/gui/jei_mid.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;

    public CrucibleRecipeCategory(IGuiHelper guiHelper, String uid) {
        this.background = guiHelper.createDrawable(texture, 0, 168, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
        this.UID = uid;
    }

    @Nonnull
    public String getUid() {
        return this.UID;
    }

    @Nonnull
    public String getTitle() {
        return "Crucible";
    }

    @Nonnull
    public String getModName() {
        return "exnihilocreatio";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull CrucibleRecipe recipe, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 2, 20);
        recipeLayout.getItemStacks().set(0, recipe.getFluid());
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 1;
        for (int i = 0; i < recipe.getInputs().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            List<ItemStack> stacks = recipe.getInputs().get(i);
            recipeLayout.getItemStacks().init(i + slotIndex, true, slotX, slotY);
            recipeLayout.getItemStacks().set(i + slotIndex, stacks);
            if (focus == null || !stacks.stream().anyMatch(stack -> ItemStack.func_179545_c((ItemStack)((ItemStack)focus.getValue()), (ItemStack)stack))) continue;
            recipeLayout.getItemStacks().setBackground(i + slotIndex, (IDrawable)this.slotHighlight);
        }
        if (this.UID.equals("exnihilocreatio:crucible_stone")) {
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new StoneCrucibleTooltipCallback());
        } else {
            recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new WoodCrucibleTooltipCallback());
        }
    }

    public IDrawable getIcon() {
        return null;
    }

    private static class WoodCrucibleTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private WoodCrucibleTooltipCallback() {
        }

        @SideOnly(value=Side.CLIENT)
        public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
            if (!input) {
                Meltable entry = ExNihiloRegistryManager.CRUCIBLE_WOOD_REGISTRY.getMeltable(ingredient);
                tooltip.add(String.format("Value: %.1f%%", Float.valueOf(1000.0f / (float)entry.getAmount())));
            }
        }
    }

    private static class StoneCrucibleTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private StoneCrucibleTooltipCallback() {
        }

        @SideOnly(value=Side.CLIENT)
        public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
            if (!input) {
                Meltable entry = ExNihiloRegistryManager.CRUCIBLE_STONE_REGISTRY.getMeltable(ingredient);
                tooltip.add(String.format("Value: %.1f%%", Float.valueOf(1000.0f / (float)entry.getAmount())));
            }
        }
    }
}

