/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.compatibility.jei.hammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import exnihilocreatio.compatibility.jei.hammer.HammerRecipe;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.HammerReward;
import exnihilocreatio.util.ItemUtil;
import exnihilocreatio.util.StringUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HammerRecipeCategory
implements IRecipeCategory<HammerRecipe> {
    public static final String UID = "exnihilocreatio:hammer";
    private static final ResourceLocation texture = new ResourceLocation("exnihilocreatio", "textures/gui/jei_mid.png");
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;

    public HammerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 56, 166, 58);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return "Hammer";
    }

    @Nonnull
    public String getModName() {
        return "exnihilocreatio";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(@Nonnull IRecipeLayout recipeLayout, @Nonnull HammerRecipe recipeWrapper, @Nonnull IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 10, 38);
        recipeLayout.getItemStacks().set(0, recipeWrapper.getInputs());
        IFocus focus = recipeLayout.getFocus();
        int slotIndex = 1;
        for (int i = 0; i < recipeWrapper.getOutputs().size(); ++i) {
            int slotX = 38 + i % 7 * 18;
            int slotY = 2 + i / 7 * 18;
            ItemStack outputStack = recipeWrapper.getOutputs().get(i);
            recipeLayout.getItemStacks().init(slotIndex + i, false, slotX, slotY);
            recipeLayout.getItemStacks().set(slotIndex + i, outputStack);
            if (focus == null) continue;
            ItemStack focusStack = (ItemStack)focus.getValue();
            if (focus.getMode() != IFocus.Mode.OUTPUT || focusStack.func_190926_b() || focusStack.func_77973_b() != outputStack.func_77973_b() || focusStack.func_77952_i() != outputStack.func_77952_i()) continue;
            recipeLayout.getItemStacks().setBackground(i + slotIndex, (IDrawable)this.slotHighlight);
        }
        recipeLayout.getItemStacks().addTooltipCallback((ITooltipCallback)new HammerTooltipCallback(recipeWrapper));
    }

    public IDrawable getIcon() {
        return null;
    }

    private static class HammerTooltipCallback
    implements ITooltipCallback<ItemStack> {
        private final HammerRecipe recipe;

        private HammerTooltipCallback(HammerRecipe recipeWrapper) {
            this.recipe = recipeWrapper;
        }

        @SideOnly(value=Side.CLIENT)
        public void onTooltip(int slotIndex, boolean input, @Nonnull ItemStack ingredient, @Nonnull List<String> tooltip) {
            if (!input) {
                ItemStack blockStack = this.recipe.getInputs().get(0);
                Block blockBase = Block.func_149634_a((Item)blockStack.func_77973_b());
                IBlockState block = blockBase.func_176203_a(blockStack.func_77960_j());
                NonNullList<HammerReward> allRewards = ExNihiloRegistryManager.HAMMER_REGISTRY.getRewards(block);
                allRewards.removeIf(reward -> !ItemUtil.areStacksEquivalent(reward.getStack(), ingredient));
                HashMap tieredOutputs = Maps.newHashMap();
                for (HammerReward reward2 : allRewards) {
                    List stacks = (List)tieredOutputs.get(reward2.getMiningLevel());
                    if (stacks == null) {
                        stacks = Lists.newArrayList((Object[])new HammerReward[]{reward2});
                        tieredOutputs.put(reward2.getMiningLevel(), stacks);
                        continue;
                    }
                    stacks.add(reward2);
                }
                tieredOutputs.forEach((level, rewards) -> rewards.sort((rewardA, rewardB) -> Float.compare(rewardB.getChance(), rewardA.getChance())));
                ArrayList levelOrder = Lists.newArrayList(tieredOutputs.keySet());
                levelOrder.sort((levelA, levelB) -> Integer.compare(levelB, levelA));
                Iterator iterator = levelOrder.iterator();
                while (iterator.hasNext()) {
                    int level2 = (Integer)iterator.next();
                    tooltip.add(I18n.func_135052_a((String)("jei.hammer.hammerLevel." + level2), (Object[])new Object[0]));
                    ((List)tieredOutputs.get(level2)).forEach(reward -> tooltip.add(String.format("%s (x%d)", StringUtils.formatPercent(reward.getChance()), reward.getStack().func_190916_E())));
                }
            }
        }
    }
}

