/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.modules;

import exnihilocreatio.ModBlocks;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.modules.IExNihiloCreatioModule;
import exnihilocreatio.modules.oreberries.ItemOreBerrySeed;
import exnihilocreatio.modules.oreberries.RenderOreBerrySeed;
import exnihilocreatio.recipes.defaults.IRecipeDefaults;
import exnihilocreatio.registries.registries.SieveRegistry;
import exnihilocreatio.util.ItemInfo;
import exnihilocreatio.util.StackInfo;
import java.util.ArrayList;
import java.util.List;
import josephcsible.oreberries.BlockOreberryBush;
import josephcsible.oreberries.proxy.CommonProxy;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;

public class OreBerries
implements IExNihiloCreatioModule,
IRecipeDefaults {
    private static final List<ItemOreBerrySeed> oreberryseeds = new ArrayList<ItemOreBerrySeed>();
    @SidedProxy(serverSide="exnihilocreatio.modules.OreBerries$Proxy", clientSide="exnihilocreatio.modules.OreBerries$ProxyClient")
    public static Proxy proxy;

    @Override
    public String getMODID() {
        return "oreberries";
    }

    @Override
    public void preInit(FMLPreInitializationEvent event) {
        for (BlockOreberryBush bush : CommonProxy.oreberryBushBlocks) {
            oreberryseeds.add(new ItemOreBerrySeed(bush));
        }
    }

    @Override
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Override
    public void registerOredicts() {
        if (ModConfig.compatibility.oreberries_compat.enableOreBerryOredict) {
            for (ItemOreBerrySeed seed : oreberryseeds) {
                OreDictionary.registerOre((String)"listAllseed", (ItemStack)new ItemStack((Item)seed));
            }
        }
    }

    @Override
    public void registerSieve(SieveRegistry registry) {
        for (ItemOreBerrySeed seed : oreberryseeds) {
            float chance = ModConfig.compatibility.oreberries_compat.baseDropChance / (float)seed.getBush().config.rarity;
            for (Integer dim : seed.getBush().config.dimensions) {
                ItemStack toSieve;
                switch (dim) {
                    case 1: {
                        toSieve = new ItemStack((Block)ModBlocks.endstoneCrushed);
                        break;
                    }
                    case -1: {
                        toSieve = new ItemStack((Block)ModBlocks.netherrackCrushed);
                        break;
                    }
                    default: {
                        toSieve = new ItemStack(Blocks.field_150346_d, 1, 1);
                    }
                }
                registry.register(toSieve, (StackInfo)new ItemInfo(seed), chance / 5.0f, BlockSieve.MeshType.IRON.getID());
                registry.register(toSieve, (StackInfo)new ItemInfo(seed), chance, BlockSieve.MeshType.DIAMOND.getID());
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static class ProxyClient
    extends Proxy {
        @Override
        public void init(FMLInitializationEvent event) {
            super.init(event);
            Minecraft.func_71410_x().getItemColors().func_186730_a((IItemColor)new RenderOreBerrySeed(), (Item[])oreberryseeds.stream().filter(seed -> seed.getBush().config.special == null).toArray(ItemOreBerrySeed[]::new));
        }
    }

    public static class Proxy {
        public void init(FMLInitializationEvent event) {
        }
    }
}

