/*
 * Decompiled with CFR 0.152.
 */
package exnihilocreatio.tiles;

import com.google.common.base.Objects;
import exnihilocreatio.ModEnchantments;
import exnihilocreatio.blocks.BlockSieve;
import exnihilocreatio.config.ModConfig;
import exnihilocreatio.registries.manager.ExNihiloRegistryManager;
import exnihilocreatio.registries.types.Siftable;
import exnihilocreatio.tiles.BaseTileEntity;
import exnihilocreatio.tiles.TileAutoSifter;
import exnihilocreatio.util.BlockInfo;
import exnihilocreatio.util.Util;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class TileSieve
extends BaseTileEntity {
    private static final Random rand = new Random();
    public TileAutoSifter autoSifter = null;
    @Nonnull
    private BlockInfo currentStack = BlockInfo.EMPTY;
    private float progress = 0.0f;
    @Nonnull
    private ItemStack meshStack = ItemStack.field_190927_a;
    private BlockSieve.MeshType meshType = BlockSieve.MeshType.NONE;
    private long lastSieveAction = 0L;
    private UUID lastPlayer;

    public boolean setMesh(ItemStack newMesh) {
        return this.setMesh(newMesh, false);
    }

    public boolean setMesh(ItemStack newMesh, boolean simulate) {
        if (this.progress != 0.0f || this.currentStack.isValid()) {
            return false;
        }
        if (this.meshStack.func_190926_b()) {
            if (!simulate) {
                this.meshStack = newMesh.func_77946_l();
                this.meshType = BlockSieve.MeshType.getMeshTypeByID(newMesh.func_77960_j());
                this.markDirtyClient();
            }
            return true;
        }
        if (newMesh.func_190926_b()) {
            if (!simulate) {
                this.meshStack = ItemStack.field_190927_a;
                this.meshType = BlockSieve.MeshType.NONE;
                this.markDirtyClient();
            }
            return true;
        }
        return false;
    }

    public boolean addBlock(ItemStack stack) {
        if (!this.currentStack.isValid() && ExNihiloRegistryManager.SIEVE_REGISTRY.canBeSifted(stack)) {
            if (this.meshStack.func_190926_b()) {
                return false;
            }
            int meshLevel = this.meshStack.func_77952_i();
            for (Siftable siftable : ExNihiloRegistryManager.SIEVE_REGISTRY.getDrops(stack)) {
                if (siftable.getMeshLevel() != meshLevel) continue;
                this.currentStack = new BlockInfo(stack);
                this.markDirtyClient();
                return true;
            }
        }
        return false;
    }

    public void doSieving(EntityPlayer player, boolean automatedSieving) {
        if (!this.field_145850_b.field_72995_K) {
            if (!this.currentStack.isValid()) {
                return;
            }
            if (this.func_145831_w().func_82737_E() - this.lastSieveAction < 4L && !automatedSieving) {
                return;
            }
            if (!automatedSieving && player != null && this.func_145831_w().func_82737_E() - this.lastSieveAction == 0L && this.lastPlayer.equals(player.func_110124_au())) {
                if (ModConfig.sieve.setFireToMacroUsers) {
                    player.func_70015_d(1);
                }
                player.func_145747_a(new TextComponentString("Bad").func_150255_a(new Style().func_150238_a(TextFormatting.RED).func_150227_a(Boolean.valueOf(true))));
            }
            this.lastSieveAction = this.func_145831_w().func_82737_E();
            if (player != null) {
                this.lastPlayer = player.func_110124_au();
            }
            float efficiency = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.EFFICIENCY, (ItemStack)this.meshStack);
            efficiency += (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)this.meshStack);
            float haste = 0.0f;
            if (ModConfig.sieve.enchantments.hasteIncreasesSpeed && player != null && player.func_70644_a(MobEffects.field_76422_e)) {
                haste = player.func_70660_b(MobEffects.field_76422_e).func_76458_c() + 1;
            }
            int fortune = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.FORTUNE, (ItemStack)this.meshStack);
            fortune += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)this.meshStack);
            if (player != null) {
                fortune = (int)((float)fortune + player.func_184817_da());
            }
            int luckOfTheSea = EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.LUCK_OF_THE_SEA, (ItemStack)this.meshStack);
            if ((luckOfTheSea += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_151370_z, (ItemStack)this.meshStack)) > 0 && player != null) {
                luckOfTheSea = (int)((float)luckOfTheSea + player.func_184817_da());
            }
            this.progress = (float)((double)this.progress + ((double)ModConfig.sieve.baseProgress + ModConfig.sieve.enchantments.efficiencyScaleFactor * (double)efficiency) * (1.0 + ModConfig.sieve.enchantments.hasteScaleFactor * (double)haste));
            this.markDirtyClient();
            if (this.progress >= 1.0f) {
                IItemHandler cap;
                List<ItemStack> drops = ExNihiloRegistryManager.SIEVE_REGISTRY.getRewardDrops(rand, this.currentStack.getBlockState(), this.meshStack.func_77960_j(), fortune);
                int fishToDrop = (int)Math.round(rand.nextGaussian() + (double)luckOfTheSea / 2.0);
                fishToDrop = MathHelper.func_76125_a((int)fishToDrop, (int)0, (int)luckOfTheSea);
                for (int i = 0; i < fishToDrop; ++i) {
                    int fishMeta = 0;
                    switch (rand.nextInt(7)) {
                        case 3: 
                        case 4: {
                            fishMeta = 1;
                            break;
                        }
                        case 5: {
                            fishMeta = 2;
                            break;
                        }
                        case 6: {
                            fishMeta = 3;
                            break;
                        }
                    }
                    drops.add(new ItemStack(Items.field_151115_aP, 1, fishMeta));
                }
                TileEntity teUp = this.field_145850_b.func_175625_s(this.field_174879_c.func_177984_a());
                if (teUp != null && teUp.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN) && (cap = (IItemHandler)teUp.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) != null) {
                    int slotAmount = cap.getSlots();
                    Iterator<ItemStack> iterator = drops.iterator();
                    while (iterator.hasNext()) {
                        ItemStack drop;
                        ItemStack newStack = drop = iterator.next();
                        for (int i = 0; i < slotAmount && !newStack.func_190926_b(); ++i) {
                            newStack = cap.insertItem(i, newStack, false);
                        }
                        if (newStack.func_190926_b()) continue;
                        Util.dropItemInWorld(this, player, newStack, 1.0);
                    }
                } else {
                    drops.forEach(stack -> Util.dropItemInWorld(this, player, stack, 1.0));
                }
                this.resetSieve();
            }
        }
    }

    public boolean isSieveSimilar(TileSieve sieve) {
        return sieve != null && !this.meshStack.func_190926_b() && !sieve.getMeshStack().func_190926_b() && this.meshStack.func_77952_i() == sieve.getMeshStack().func_77952_i() && this.progress == sieve.getProgress() && this.currentStack.isValid() && this.currentStack.equals(sieve.getCurrentStack());
    }

    public boolean isSieveSimilarToInput(TileSieve sieve) {
        return !this.meshStack.func_190926_b() && !sieve.getMeshStack().func_190926_b() && this.meshStack.func_77952_i() == sieve.getMeshStack().func_77952_i() && this.progress == sieve.getProgress() && !sieve.getCurrentStack().isValid();
    }

    private void resetSieve() {
        this.progress = 0.0f;
        this.currentStack = BlockInfo.EMPTY;
        this.markDirtyClient();
    }

    public void validateAutoSieve() {
        if (this.autoSifter == null || this.autoSifter.func_145837_r() || !(this.field_145850_b.func_175625_s(this.autoSifter.func_174877_v()) instanceof TileAutoSifter) && this.autoSifter.toSift != null) {
            this.autoSifter = null;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        if (this.currentStack.isValid()) {
            return Util.getTextureFromBlockState(this.currentStack.getBlockState());
        }
        return null;
    }

    public boolean shouldRefresh(World world, BlockPos pos, @Nonnull IBlockState oldState, @Nonnull IBlockState newState) {
        return oldState.func_177230_c() != newState.func_177230_c();
    }

    @Nonnull
    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        if (this.currentStack.isValid()) {
            NBTTagCompound stackTag = this.currentStack.writeToNBT(new NBTTagCompound());
            tag.func_74782_a("stack", (NBTBase)stackTag);
        }
        if (!this.meshStack.func_190926_b()) {
            NBTTagCompound meshTag = this.meshStack.func_77955_b(new NBTTagCompound());
            tag.func_74782_a("mesh", (NBTBase)meshTag);
        }
        tag.func_74776_a("progress", this.progress);
        return super.func_189515_b(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        this.currentStack = tag.func_74764_b("stack") ? BlockInfo.readFromNBT(tag.func_74775_l("stack")) : BlockInfo.EMPTY;
        if (tag.func_74764_b("mesh")) {
            this.meshStack = new ItemStack(tag.func_74775_l("mesh"));
            this.meshType = BlockSieve.MeshType.getMeshTypeByID(this.meshStack.func_77960_j());
        } else {
            this.meshStack = ItemStack.field_190927_a;
            this.meshType = BlockSieve.MeshType.NONE;
        }
        this.progress = tag.func_74760_g("progress");
        super.func_145839_a(tag);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p()});
    }

    @Nonnull
    public BlockInfo getCurrentStack() {
        return this.currentStack;
    }

    public float getProgress() {
        return this.progress;
    }

    @Nonnull
    public ItemStack getMeshStack() {
        return this.meshStack;
    }

    public BlockSieve.MeshType getMeshType() {
        return this.meshType;
    }
}

