/*
 * Decompiled with CFR 0.152.
 */
package com.m4thg33k.tombmanygraves.invman;

import com.m4thg33k.tombmanygraves.ModConfigs;
import com.m4thg33k.tombmanygraves.invman.InventoryHolder;
import com.m4thg33k.tombmanygraves.items.ModItems;
import com.m4thg33k.tombmanygraves.util.ChatHelper;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;

public class DeathInventoryHandler {
    private static String FILE_PREFIX = "./TombManyGraves/savedInventories";

    public static boolean checkFilePath() {
        File file = new File(FILE_PREFIX);
        boolean hasPath = true;
        if (!file.exists()) {
            hasPath = file.mkdirs();
        }
        return hasPath;
    }

    public static boolean writeInventoryFile(InventoryHolder inventoryHolder) {
        boolean hasPath = DeathInventoryHandler.checkFilePath();
        if (!ModConfigs.ALLOW_INVENTORY_SAVES || !hasPath) {
            return false;
        }
        boolean didWork = false;
        String filename = "/" + inventoryHolder.getPlayerName();
        String timestamp = inventoryHolder.getTimestamp();
        String filePostfix = timestamp + ".json";
        String fullFilename = FILE_PREFIX + filename + "#" + filePostfix;
        NBTTagCompound tagCompound = new NBTTagCompound();
        didWork = DeathInventoryHandler.writePortion(fullFilename, (tagCompound = inventoryHolder.writeToNBT(tagCompound)).toString());
        if (didWork) {
            try {
                Path from = Paths.get(fullFilename, new String[0]);
                Path to = Paths.get(FILE_PREFIX + filename + "#latest.json", new String[0]);
                Files.copy(from, to, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return didWork;
    }

    private static boolean writePortion(String filename, String toWrite) {
        boolean didWork = true;
        try (FileWriter file = new FileWriter(filename);){
            file.write(toWrite);
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            didWork = false;
        }
        return didWork;
    }

    public static void clearLatest(EntityPlayer player) {
        String filename = "/" + player.func_70005_c_();
        String timestamp = "latest";
        String filePostfix = timestamp + ".json";
        String fullFilename = FILE_PREFIX + filename + "#" + filePostfix;
        DeathInventoryHandler.writePortion(fullFilename, "{}");
    }

    public static List<String> getSavedInventories() {
        String[] files;
        ArrayList<String> saved = new ArrayList<String>();
        boolean doesPathExist = DeathInventoryHandler.checkFilePath();
        if (!doesPathExist) {
            return saved;
        }
        for (String file : files = new File(FILE_PREFIX).list()) {
            if (!file.endsWith(".json")) continue;
            saved.add(file);
        }
        return saved;
    }

    public static List<String> getFilenames(String playerName) {
        String[] files;
        ArrayList<String> saved = new ArrayList<String>();
        boolean doesPathExist = DeathInventoryHandler.checkFilePath();
        if (!doesPathExist) {
            return saved;
        }
        for (String file : files = new File(FILE_PREFIX).list()) {
            if (!file.startsWith(playerName) || !file.endsWith(".json")) continue;
            saved.add(file.substring(playerName.length() + 1, file.length() - 5));
        }
        return saved;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ItemStack getDeathListFromFile(String playerName, String timestamp) {
        String filename = FILE_PREFIX + "/" + playerName + "#" + timestamp + ".json";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(filename));
            String fileData = reader.readLine();
            NBTTagCompound allNBT = JsonToNBT.func_180713_a((String)fileData);
            if (allNBT.func_150296_c().size() > 0) {
                ItemStack theList = new ItemStack((Item)ModItems.itemDeathList, 1);
                theList.func_77982_d(allNBT);
                ItemStack itemStack = theList;
                return itemStack;
            }
            ItemStack theList = null;
            return theList;
        }
        catch (Exception e) {
            ItemStack itemStack = null;
            return itemStack;
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static boolean getDeathList(EntityPlayer playerOld, EntityPlayer playerNew, String playerName, String timestamp, boolean didDie) {
        boolean didWork = true;
        String filename = FILE_PREFIX + "/" + playerName + "#" + timestamp + ".json";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String fileData = reader.readLine();
            NBTTagCompound allNBT = JsonToNBT.func_180713_a((String)fileData);
            if (allNBT.func_150296_c().size() > 0) {
                ItemStack theList = new ItemStack((Item)ModItems.itemDeathList, 1);
                theList.func_77982_d(allNBT);
                BlockPos pos = playerOld.func_180425_c();
                EntityPlayer thePlayer = playerOld;
                if (didDie) {
                    thePlayer = playerNew;
                    BlockPos bedPos = playerOld.getBedLocation(playerOld.field_70170_p.field_73011_w.getDimension());
                    pos = bedPos != null ? bedPos : ((bedPos = playerOld.getBedLocation(playerOld.getSpawnDimension())) != null ? bedPos : playerOld.field_70170_p.func_175694_M());
                }
                EntityItem entityItem = new EntityItem(thePlayer.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), theList);
                thePlayer.field_70170_p.func_72838_d((Entity)entityItem);
            } else {
                ChatHelper.sayMessage(playerOld.field_70170_p, playerOld, playerName + " had no items upon death!");
            }
            reader.close();
        }
        catch (Exception e) {
            didWork = false;
        }
        return didWork;
    }

    public static NBTTagCompound getSavedInventoryAsNBT(String playerName, String timestamp) {
        String filename = FILE_PREFIX + "/" + playerName + "#" + timestamp + ".json";
        try {
            BufferedReader reader = new BufferedReader(new FileReader(filename));
            String fileData = reader.readLine();
            NBTTagCompound allNBT = JsonToNBT.func_180713_a((String)fileData);
            reader.close();
            return allNBT;
        }
        catch (Exception e) {
            return null;
        }
    }
}

