/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.blocks.ores;

import com.google.common.base.Predicate;
import com.kashdeya.tinyprogressions.main.TinyProgressions;
import com.kashdeya.tinyprogressions.registry.utils.IOreDictEntry;
import java.util.ArrayList;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.stats.StatList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LavaBlock
extends Block
implements IOreDictEntry {
    public static final PropertyInteger LEVEL = PropertyInteger.func_177719_a((String)"level", (int)0, (int)15);

    public LavaBlock() {
        super(Material.field_151578_c);
        this.func_149711_c(1.0f);
        this.func_149752_b(5.0f);
        this.func_149715_a(0.2f);
        this.func_149675_a(true);
        this.func_149663_c("lava_block");
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149647_a(TinyProgressions.tabTP);
    }

    @Override
    public String getOreDictName() {
        return "oreLavaBlock";
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean doesSideBlockRendering(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing face) {
        return false;
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        player.func_71029_a(StatList.func_188055_a((Block)this));
        player.func_71020_j(0.025f);
        if (this.canSilkHarvest(worldIn, pos, state, player) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)stack) > 0) {
            ArrayList<ItemStack> items = new ArrayList<ItemStack>();
            ItemStack itemstack = this.func_180643_i(state);
            if (!itemstack.func_190926_b()) {
                items.add(itemstack);
            }
            ForgeEventFactory.fireBlockHarvesting(items, (World)worldIn, (BlockPos)pos, (IBlockState)state, (int)0, (float)1.0f, (boolean)true, (EntityPlayer)player);
            items.forEach(item -> LavaBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)item));
        } else {
            worldIn.func_175656_a(pos, Blocks.field_150356_k.func_176223_P());
        }
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public void func_180658_a(World worldIn, BlockPos pos, Entity entityIn, float fallDistance) {
        entityIn.func_180430_e(fallDistance, 3.0f);
    }

    public void func_176199_a(World worldIn, BlockPos pos, Entity entityIn) {
        entityIn.field_70159_w *= 0.8;
        entityIn.field_70179_y *= 0.8;
        if (!entityIn.func_70045_F() && entityIn instanceof EntityLivingBase && !EnchantmentHelper.func_189869_j((EntityLivingBase)((EntityLivingBase)entityIn))) {
            entityIn.func_70097_a(DamageSource.field_190095_e, 1.0f);
        }
        super.func_176199_a(worldIn, pos, entityIn);
    }

    public boolean isReplaceableOreGen(IBlockState state, IBlockAccess world, BlockPos pos, Predicate<IBlockState> target) {
        return false;
    }

    public boolean func_189872_a(IBlockState state, Entity entityIn) {
        return entityIn.func_70045_F();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess source, BlockPos pos) {
        int i = source.func_175626_b(pos, 0);
        int j = source.func_175626_b(pos.func_177984_a(), 0);
        int k = i & 0xFF;
        int l = j & 0xFF;
        int i1 = i >> 16 & 0xFF;
        int j1 = j >> 16 & 0xFF;
        return (k > l ? k : l) | (i1 > j1 ? i1 : j1) << 16;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState worldIn, World pos, BlockPos state, Random rand) {
        double d0 = state.func_177958_n();
        double d1 = state.func_177956_o();
        double d2 = state.func_177952_p();
        if (rand.nextInt(100) == 0) {
            double d8 = d0 + (double)rand.nextFloat();
            double d4 = d1 + worldIn.func_185900_c((IBlockAccess)pos, (BlockPos)state).field_72337_e;
            double d6 = d2 + (double)rand.nextFloat();
            pos.func_175688_a(EnumParticleTypes.LAVA, d8, d4, d6, 0.0, 0.0, 0.0, new int[0]);
            pos.func_184134_a(d8, d4, d6, SoundEvents.field_187662_cZ, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
        }
        if (rand.nextInt(200) == 0) {
            pos.func_184134_a(d0, d1, d2, SoundEvents.field_187656_cX, SoundCategory.BLOCKS, 0.2f + rand.nextFloat() * 0.2f, 0.9f + rand.nextFloat() * 0.15f, false);
        }
        if (rand.nextInt(100) == 0) {
            double d3 = d0 + (double)rand.nextFloat();
            double d7 = d2 + (double)rand.nextFloat();
            pos.func_175688_a(EnumParticleTypes.DRIP_LAVA, d3, d1, d7, 0.0, 0.0, 0.0, new int[0]);
        }
    }
}

