/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.tiles;

import com.kashdeya.tinyprogressions.blocks.oredoubler.IronFurnaceBlock;
import com.kashdeya.tinyprogressions.capabilities.InventoryStorage;
import com.kashdeya.tinyprogressions.inits.TechBlocks;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;

public class TileEntityOreDoubler
extends TileEntity
implements ITickable {
    private int furnaceBurnTime;
    private int currentItemBurnTime;
    private int cookTime;
    private int totalCookTime;
    private String furnaceCustomName;
    private int cookSpeed = 200;
    public InventoryStorage inputInventory = new InventoryStorage(1){

        @Override
        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            TileEntityOreDoubler.this.totalCookTime = TileEntityOreDoubler.this.getCookTime(TileEntityOreDoubler.this.inputInventory.getStackInSlot(0));
            return super.insertItem(slot, stack, simulate);
        }

        @Override
        public boolean canExtractSlot(int slot) {
            return false;
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74782_a("inputInventory", (NBTBase)this.serializeNBT());
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            this.deserializeNBT(compound.func_74775_l("inputInventory"));
        }
    };
    public InventoryStorage outputInventory = new InventoryStorage(4){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return false;
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74782_a("outputInventory", (NBTBase)this.serializeNBT());
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            this.deserializeNBT(compound.func_74775_l("outputInventory"));
        }
    };
    public InventoryStorage fuelInventory = new InventoryStorage(1){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return TileEntityFurnace.func_145954_b((ItemStack)stack);
        }

        @Override
        public boolean canExtractSlot(int slot) {
            return false;
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74782_a("fuelInventory", (NBTBase)this.serializeNBT());
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            this.deserializeNBT(compound.func_74775_l("fuelInventory"));
        }
    };

    public TileEntityOreDoubler setCookSpeed(int ticksIn) {
        this.cookSpeed = ticksIn;
        return this;
    }

    public void func_73660_a() {
        boolean flag = this.isBurning();
        boolean flag1 = false;
        if (this.isBurning()) {
            --this.furnaceBurnTime;
        }
        if (!this.field_145850_b.field_72995_K) {
            ItemStack itemstackFuelSlot = this.fuelInventory.getStackInSlot(0);
            if (this.isBurning() || !itemstackFuelSlot.func_190926_b() && !this.inputInventory.getStackInSlot(0).func_190926_b()) {
                if (!this.isBurning() && this.canSmelt()) {
                    this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)itemstackFuelSlot);
                    if (this.isBurning()) {
                        flag1 = true;
                        if (!itemstackFuelSlot.func_190926_b()) {
                            Item item = itemstackFuelSlot.func_77973_b();
                            itemstackFuelSlot.func_190918_g(1);
                            if (itemstackFuelSlot.func_190926_b()) {
                                ItemStack item1 = item.getContainerItem(itemstackFuelSlot);
                                this.fuelInventory.setStackInSlot(0, item1);
                            }
                        }
                    }
                }
                if (this.isBurning() && this.canSmelt()) {
                    ++this.cookTime;
                    if (this.cookTime == this.getCookTime(this.inputInventory.getStackInSlot(0))) {
                        this.cookTime = 0;
                        this.totalCookTime = this.getCookTime(this.inputInventory.getStackInSlot(0));
                        this.smeltItem();
                        flag1 = true;
                    }
                } else {
                    this.cookTime = 0;
                }
            } else if (!this.isBurning() && this.cookTime > 0) {
                this.cookTime = MathHelper.func_76125_a((int)(this.cookTime - 2), (int)0, (int)this.totalCookTime);
            }
            if (flag != this.isBurning()) {
                flag1 = true;
                IronFurnaceBlock.setBurning(this.field_145850_b, this.field_174879_c, this.isBurning());
            }
        }
        if (flag1) {
            this.func_70296_d();
        }
    }

    public boolean isBurning() {
        return this.furnaceBurnTime > 0;
    }

    private boolean canSmelt() {
        if (this.inputInventory.getStackInSlot(0).func_190926_b()) {
            return false;
        }
        ItemStack itemstack = FurnaceRecipes.func_77602_a().func_151395_a(this.inputInventory.getStackInSlot(0));
        if (itemstack.func_190926_b()) {
            return false;
        }
        ItemStack itemstack1 = itemstack.func_77946_l();
        for (int outputSlot = 0; outputSlot < this.outputInventory.getSlots(); ++outputSlot) {
            if (!(itemstack1 = this.outputInventory.insertItemInternal(outputSlot, itemstack1, true)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public void smeltItem() {
        if (this.canSmelt()) {
            ItemStack itemstackInput = this.inputInventory.getStackInSlot(0);
            ItemStack itemstackResult = FurnaceRecipes.func_77602_a().func_151395_a(itemstackInput);
            for (int outputSlot = 0; outputSlot < this.outputInventory.getSlots() && !itemstackResult.func_190926_b(); ++outputSlot) {
                if (itemstackInput.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150360_v) && itemstackInput.func_77960_j() == 1 && !this.fuelInventory.getStackInSlot(0).func_190926_b() && this.fuelInventory.getStackInSlot(0).func_77973_b() == Items.field_151133_ar) {
                    this.fuelInventory.setStackInSlot(0, new ItemStack(Items.field_151131_as));
                    continue;
                }
                itemstackResult = this.outputInventory.insertItemInternal(outputSlot, itemstackResult.func_77946_l(), false);
            }
            itemstackInput.func_190918_g(1);
        }
    }

    public int getCookTime(ItemStack stack) {
        return this.cookSpeed;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.inputInventory.readFromNBT(compound);
        this.outputInventory.readFromNBT(compound);
        this.fuelInventory.readFromNBT(compound);
        this.furnaceBurnTime = compound.func_74762_e("BurnTime");
        this.cookTime = compound.func_74762_e("CookTime");
        this.totalCookTime = compound.func_74762_e("CookTimeTotal");
        this.currentItemBurnTime = TileEntityFurnace.func_145952_a((ItemStack)this.fuelInventory.getStackInSlot(0));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("BurnTime", (int)((short)this.furnaceBurnTime));
        compound.func_74768_a("CookTime", (int)((short)this.cookTime));
        compound.func_74768_a("CookTimeTotal", (int)((short)this.totalCookTime));
        this.inputInventory.writeToNBT(compound);
        this.outputInventory.writeToNBT(compound);
        this.fuelInventory.writeToNBT(compound);
        return compound;
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        if (oldState.func_177230_c() == TechBlocks.iron_furnace_block && newSate.func_177230_c() == TechBlocks.iron_furnace_block) {
            return false;
        }
        return oldState != newSate;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.UP) {
            return (T)((Object)this.inputInventory);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && (facing == EnumFacing.EAST || facing == EnumFacing.WEST || facing == EnumFacing.NORTH || facing == EnumFacing.SOUTH)) {
            return (T)((Object)this.fuelInventory);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY && facing == EnumFacing.DOWN) {
            return (T)((Object)this.outputInventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public int getField(int id) {
        switch (id) {
            case 0: {
                return this.furnaceBurnTime;
            }
            case 1: {
                return this.currentItemBurnTime;
            }
            case 2: {
                return this.cookTime;
            }
            case 3: {
                return this.totalCookTime;
            }
        }
        return 0;
    }

    public void setField(int id, int value) {
        switch (id) {
            case 0: {
                this.furnaceBurnTime = value;
                break;
            }
            case 1: {
                this.currentItemBurnTime = value;
                break;
            }
            case 2: {
                this.cookTime = value;
                break;
            }
            case 3: {
                this.totalCookTime = value;
            }
        }
    }

    public static boolean isBurning(TileEntityOreDoubler oredoubler) {
        return oredoubler.isBurning();
    }
}

