/*
 * Decompiled with CFR 0.152.
 */
package noppes.vc;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketCustomSound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import noppes.vc.VCWeapons;
import noppes.vc.client.VCSounds;

public class EntityHolyHandGrenade
extends EntityThrowable {
    private static final DataParameter<Boolean> Gravity = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Arrow = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Is3d = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Glows = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Rotating = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> Sticks = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> Velocity = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> Particle = EntityDataManager.func_187226_a(EntityHolyHandGrenade.class, (DataSerializer)DataSerializers.field_187192_b);
    private BlockPos tilePos = BlockPos.field_177992_a;
    private Block inTile;
    public boolean field_174854_a = false;
    private int inData = 0;
    public boolean canBePickedUp = false;
    public boolean destroyedOnEntityHit = true;
    private EntityLivingBase thrower;
    private String throwerName = null;
    private int ticksInGround;
    public int field_70195_i = 0;
    private double accelerationX;
    private double accelerationY;
    private double accelerationZ;
    public float damage = 5.0f;
    public int punch = 0;
    public boolean accelerate = false;
    public boolean explosiveDamage = true;
    public int explosiveRadius = 0;
    public int duration = 5;
    public int timeToLive = 1200;

    public EntityHolyHandGrenade(World par1World) {
        super(par1World);
        this.func_70105_a(0.2f, 0.2f);
    }

    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(Velocity, (Object)10);
        this.field_70180_af.func_187214_a(Particle, (Object)0);
        this.field_70180_af.func_187214_a(Gravity, (Object)false);
        this.field_70180_af.func_187214_a(Glows, (Object)false);
        this.field_70180_af.func_187214_a(Arrow, (Object)false);
        this.field_70180_af.func_187214_a(Is3d, (Object)false);
        this.field_70180_af.func_187214_a(Rotating, (Object)false);
        this.field_70180_af.func_187214_a(Sticks, (Object)false);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        double d1 = this.func_174813_aQ().func_72320_b() * 4.0;
        return par1 < (d1 *= 64.0) * d1;
    }

    public EntityHolyHandGrenade(World par1World, EntityLivingBase par2EntityLiving, ItemStack item) {
        super(par1World);
        this.thrower = par2EntityLiving;
        if (this.thrower != null) {
            this.throwerName = this.thrower.func_110124_au().toString();
        }
        this.field_70180_af.func_187227_b(Arrow, (Object)(this.getItem() == Items.field_151032_g ? 1 : 0));
        this.func_70012_b(par2EntityLiving.field_70165_t, par2EntityLiving.field_70163_u + (double)par2EntityLiving.func_70047_e(), par2EntityLiving.field_70161_v, par2EntityLiving.field_70177_z, par2EntityLiving.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.1f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * 0.1f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public void func_70186_c(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        float f3 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        float yaw = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        float pitch = this.hasGravity() ? par7 : (float)(Math.atan2(par3, f3) * 180.0 / Math.PI);
        this.field_70126_B = this.field_70177_z = yaw;
        this.field_70127_C = this.field_70125_A = pitch;
        this.field_70159_w = MathHelper.func_76126_a((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI));
        this.field_70179_y = MathHelper.func_76134_b((float)(yaw / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(pitch / 180.0f * (float)Math.PI));
        this.field_70181_x = MathHelper.func_76126_a((float)((pitch + 1.0f) / 180.0f * (float)Math.PI));
        this.field_70159_w += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70179_y += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70181_x += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)par8;
        this.field_70159_w *= (double)this.getSpeed();
        this.field_70179_y *= (double)this.getSpeed();
        this.field_70181_x *= (double)this.getSpeed();
        this.accelerationX = par1 / (double)f2 * 0.1;
        this.accelerationY = par3 / (double)f2 * 0.1;
        this.accelerationZ = par5 / (double)f2 * 0.1;
        this.ticksInGround = 0;
    }

    public float getAngleForXYZ(double varX, double varY, double varZ, double horiDist, boolean arc) {
        float g = this.func_70185_h();
        float var1 = this.getSpeed() * this.getSpeed();
        double var2 = (double)g * horiDist;
        double var3 = (double)g * horiDist * horiDist + 2.0 * varY * (double)var1;
        double var4 = (double)(var1 * var1) - (double)g * var3;
        if (var4 < 0.0) {
            return 30.0f;
        }
        float var6 = arc ? var1 + MathHelper.func_76133_a((double)var4) : var1 - MathHelper.func_76133_a((double)var4);
        float var7 = (float)(Math.atan2(var6, var2) * 180.0 / Math.PI);
        return var7;
    }

    public void shoot(float speed) {
        double varX = -MathHelper.func_76126_a((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double varZ = MathHelper.func_76134_b((float)(this.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        double varY = -MathHelper.func_76126_a((float)(this.field_70125_A / 180.0f * (float)Math.PI));
        this.func_70186_c(varX, varY, varZ, -this.field_70125_A, speed);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180426_a(double par1, double par3, double par5, float par7, float par8, int par9, boolean bo) {
        if (this.field_70170_p.field_72995_K && this.field_174854_a) {
            return;
        }
        this.func_70107_b(par1, par3, par5);
        this.func_70101_b(par7, par8);
    }

    public void func_70071_h_() {
        AxisAlignedBB axisalignedbb;
        super.func_70030_z();
        IBlockState state = null;
        try {
            state = this.field_70170_p.func_180495_p(this.tilePos);
        }
        catch (Exception e) {
            return;
        }
        Block block = state.func_177230_c();
        if ((this.isArrow() || this.sticksToWalls()) && this.tilePos != BlockPos.field_177992_a && (axisalignedbb = state.func_185890_d((IBlockAccess)this.field_70170_p, this.tilePos)) != null && axisalignedbb.func_72318_a(new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v))) {
            this.field_174854_a = true;
        }
        if (this.field_174854_a) {
            int j = block.func_176201_c(state);
            if (block == this.inTile && j == this.inData) {
                ++this.ticksInGround;
                if (this.ticksInGround == this.timeToLive) {
                    this.func_70106_y();
                    boolean flag = ForgeEventFactory.getMobGriefingEvent((World)this.field_70170_p, (Entity)this);
                    this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u, this.field_70161_v, 10.0f, flag);
                }
            } else {
                this.field_174854_a = false;
                this.field_70159_w *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70181_x *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.field_70179_y *= (double)(this.field_70146_Z.nextFloat() * 0.2f);
                this.ticksInGround = 0;
                this.field_70195_i = 0;
            }
        } else {
            Vec3d vec31;
            Vec3d vec3;
            RayTraceResult movingobjectposition;
            ++this.field_70195_i;
            if (this.field_70195_i == 1200) {
                this.func_70106_y();
            }
            if ((movingobjectposition = this.field_70170_p.func_147447_a(vec3 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), vec31 = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y), false, true, false)) != null) {
                if (movingobjectposition.field_72313_a == RayTraceResult.Type.BLOCK && this.field_70170_p.func_180495_p(movingobjectposition.func_178782_a()).func_177230_c() == Blocks.field_150427_aO) {
                    this.func_181015_d(movingobjectposition.func_178782_a());
                } else {
                    this.field_70180_af.func_187227_b(Rotating, (Object)false);
                    this.func_70184_a(movingobjectposition);
                }
            }
            this.field_70165_t += this.field_70159_w;
            this.field_70163_u += this.field_70181_x;
            this.field_70161_v += this.field_70179_y;
            float f1 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y));
            this.field_70177_z = (float)(Math.atan2(this.field_70159_w, this.field_70179_y) * 180.0 / Math.PI);
            while (this.field_70177_z - this.field_70126_B < -180.0f) {
                this.field_70126_B -= 360.0f;
            }
            while (this.field_70177_z - this.field_70126_B >= 180.0f) {
                this.field_70126_B += 360.0f;
            }
            this.field_70127_C = this.field_70125_A;
            this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B);
            if (this.isRotating()) {
                this.field_70125_A += this.getSpeed() * -60.0f;
            }
            float f2 = this.getMotionFactor();
            float f3 = this.func_70185_h();
            if (this.func_70090_H()) {
                if (this.field_70170_p.field_72995_K) {
                    for (int k = 0; k < 4; ++k) {
                        float f4 = 0.25f;
                        this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_BUBBLE, this.field_70165_t - this.field_70159_w * (double)f4, this.field_70163_u - this.field_70181_x * (double)f4, this.field_70161_v - this.field_70179_y * (double)f4, this.field_70159_w, this.field_70181_x, this.field_70179_y, new int[0]);
                    }
                }
                f2 = 0.8f;
            }
            this.field_70159_w *= (double)f2;
            this.field_70181_x *= (double)f2;
            this.field_70179_y *= (double)f2;
            if (this.hasGravity()) {
                this.field_70181_x -= (double)f3;
            }
            if (this.accelerate) {
                this.field_70159_w += this.accelerationX;
                this.field_70181_x += this.accelerationY;
                this.field_70179_y += this.accelerationZ;
            }
            this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            this.func_145775_I();
        }
    }

    public static void playSound(Entity entity, SoundEvent sound, float volume, float pitch) {
        if (!entity.field_70170_p.field_72995_K && sound != null && sound.getRegistryName() != null) {
            SPacketCustomSound packet = new SPacketCustomSound(sound.getRegistryName().toString(), SoundCategory.NEUTRAL, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, volume, pitch);
            Optional.ofNullable(entity.func_184102_h()).ifPresent(server -> server.func_184103_al().func_148543_a(null, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, volume > 1.0f ? (double)(16.0f * volume) : 16.0, entity.field_70170_p.field_73011_w.getDimension(), (Packet)packet));
        }
    }

    public boolean isBlock() {
        ItemStack item = this.getItemDisplay();
        if (item.func_190926_b()) {
            return false;
        }
        return item.func_77973_b() instanceof ItemBlock;
    }

    private Item getItem() {
        ItemStack item = this.getItemDisplay();
        if (item.func_190926_b()) {
            return Items.field_190931_a;
        }
        return item.func_77973_b();
    }

    protected float getMotionFactor() {
        return this.accelerate ? 0.95f : 1.0f;
    }

    protected void func_70184_a(RayTraceResult movingobjectposition) {
        if (movingobjectposition.field_72308_g != null) {
            this.field_70159_w *= (double)-0.1f;
            this.field_70181_x *= (double)-0.1f;
            this.field_70179_y *= (double)-0.1f;
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            this.field_70195_i = 0;
        } else {
            this.tilePos = movingobjectposition.func_178782_a();
            try {
                IBlockState state = this.field_70170_p.func_180495_p(this.tilePos);
                this.inTile = state.func_177230_c();
                this.inData = this.inTile.func_176201_c(state);
                if (this.inTile != null) {
                    this.inTile.func_180634_a(this.field_70170_p, this.tilePos, state, (Entity)this);
                }
                EntityHolyHandGrenade.playSound((Entity)this, VCSounds.HALLELUJAH, 4.0f, 1.0f);
            }
            catch (Exception state) {
                // empty catch block
            }
            this.field_70159_w = (float)(movingobjectposition.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(movingobjectposition.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(movingobjectposition.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.field_174854_a = true;
            if (!this.hasGravity()) {
                this.field_70180_af.func_187227_b(Gravity, (Object)true);
            }
        }
    }

    public void func_70014_b(NBTTagCompound par1NBTTagCompound) {
        par1NBTTagCompound.func_74777_a("xTile", (short)this.tilePos.func_177958_n());
        par1NBTTagCompound.func_74777_a("yTile", (short)this.tilePos.func_177956_o());
        par1NBTTagCompound.func_74777_a("zTile", (short)this.tilePos.func_177952_p());
        par1NBTTagCompound.func_74774_a("inTile", (byte)Block.func_149682_b((Block)this.inTile));
        par1NBTTagCompound.func_74774_a("inData", (byte)this.inData);
        par1NBTTagCompound.func_74774_a("shake", (byte)this.field_70191_b);
        par1NBTTagCompound.func_74757_a("inGround", this.field_174854_a);
        par1NBTTagCompound.func_74757_a("isArrow", this.isArrow());
        par1NBTTagCompound.func_74782_a("direction", (NBTBase)this.func_70087_a(new double[]{this.field_70159_w, this.field_70181_x, this.field_70179_y}));
        par1NBTTagCompound.func_74757_a("canBePickedUp", this.canBePickedUp);
        if ((this.throwerName == null || this.throwerName.length() == 0) && this.thrower != null && this.thrower instanceof EntityPlayer) {
            this.throwerName = this.thrower.func_110124_au().toString();
        }
        par1NBTTagCompound.func_74778_a("ownerName", this.throwerName == null ? "" : this.throwerName);
        par1NBTTagCompound.func_74782_a("Item", (NBTBase)this.getItemDisplay().func_77955_b(new NBTTagCompound()));
        par1NBTTagCompound.func_74776_a("damagev2", this.damage);
        par1NBTTagCompound.func_74768_a("punch", this.punch);
        par1NBTTagCompound.func_74768_a("velocity", ((Integer)this.field_70180_af.func_187225_a(Velocity)).intValue());
        par1NBTTagCompound.func_74768_a("explosiveRadius", this.explosiveRadius);
        par1NBTTagCompound.func_74768_a("effectDuration", this.duration);
        par1NBTTagCompound.func_74757_a("gravity", this.hasGravity());
        par1NBTTagCompound.func_74757_a("accelerate", this.accelerate);
        par1NBTTagCompound.func_74757_a("glows", ((Boolean)this.field_70180_af.func_187225_a(Glows)).booleanValue());
        par1NBTTagCompound.func_74768_a("trailenum", ((Integer)this.field_70180_af.func_187225_a(Particle)).intValue());
        par1NBTTagCompound.func_74757_a("Render3D", ((Boolean)this.field_70180_af.func_187225_a(Is3d)).booleanValue());
        par1NBTTagCompound.func_74757_a("Spins", ((Boolean)this.field_70180_af.func_187225_a(Rotating)).booleanValue());
        par1NBTTagCompound.func_74757_a("Sticks", ((Boolean)this.field_70180_af.func_187225_a(Sticks)).booleanValue());
    }

    public void func_70037_a(NBTTagCompound compound) {
        this.tilePos = new BlockPos((int)compound.func_74765_d("xTile"), (int)compound.func_74765_d("yTile"), (int)compound.func_74765_d("zTile"));
        this.inTile = Block.func_149729_e((int)(compound.func_74771_c("inTile") & 0xFF));
        this.inData = compound.func_74771_c("inData") & 0xFF;
        this.field_70191_b = compound.func_74771_c("shake") & 0xFF;
        this.field_174854_a = compound.func_74771_c("inGround") == 1;
        this.field_70180_af.func_187227_b(Arrow, (Object)compound.func_74767_n("isArrow"));
        this.throwerName = compound.func_74779_i("ownerName");
        this.canBePickedUp = compound.func_74767_n("canBePickedUp");
        this.damage = compound.func_74760_g("damagev2");
        this.punch = compound.func_74762_e("punch");
        this.explosiveRadius = compound.func_74762_e("explosiveRadius");
        this.duration = compound.func_74762_e("effectDuration");
        this.accelerate = compound.func_74767_n("accelerate");
        this.field_70180_af.func_187227_b(Particle, (Object)compound.func_74762_e("trailenum"));
        this.field_70180_af.func_187227_b(Glows, (Object)compound.func_74767_n("glows"));
        this.field_70180_af.func_187227_b(Velocity, (Object)compound.func_74762_e("velocity"));
        this.field_70180_af.func_187227_b(Gravity, (Object)compound.func_74767_n("gravity"));
        this.field_70180_af.func_187227_b(Is3d, (Object)compound.func_74767_n("Render3D"));
        this.field_70180_af.func_187227_b(Rotating, (Object)compound.func_74767_n("Spins"));
        this.field_70180_af.func_187227_b(Sticks, (Object)compound.func_74767_n("Sticks"));
        if (this.throwerName != null && this.throwerName.length() == 0) {
            this.throwerName = null;
        }
        if (compound.func_74764_b("direction")) {
            NBTTagList nbttaglist = compound.func_150295_c("direction", 6);
            this.field_70159_w = nbttaglist.func_150309_d(0);
            this.field_70181_x = nbttaglist.func_150309_d(1);
            this.field_70179_y = nbttaglist.func_150309_d(2);
        }
    }

    public EntityLivingBase func_85052_h() {
        if (this.throwerName == null || this.throwerName.isEmpty()) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(this.throwerName);
            if (this.thrower == null && uuid != null) {
                this.thrower = this.field_70170_p.func_152378_a(uuid);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return this.thrower;
    }

    public void setParticleEffect(int type) {
        this.field_70180_af.func_187227_b(Particle, (Object)type);
    }

    public void setHasGravity(boolean bo) {
        this.field_70180_af.func_187227_b(Gravity, (Object)bo);
    }

    public void setIs3D(boolean bo) {
        this.field_70180_af.func_187227_b(Is3d, (Object)bo);
    }

    public void setStickInWall(boolean bo) {
        this.field_70180_af.func_187227_b(Sticks, (Object)bo);
    }

    public ItemStack getItemDisplay() {
        return new ItemStack(VCWeapons.holy_hand_grenade);
    }

    public float func_70013_c() {
        return (Boolean)this.field_70180_af.func_187225_a(Glows) != false ? 1.0f : super.func_70013_c();
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        return (Boolean)this.field_70180_af.func_187225_a(Glows) != false ? 0xF000F0 : super.func_70070_b();
    }

    public boolean hasGravity() {
        return (Boolean)this.field_70180_af.func_187225_a(Gravity);
    }

    public void setSpeed(int speed) {
        this.field_70180_af.func_187227_b(Velocity, (Object)speed);
    }

    public float getSpeed() {
        return (float)((Integer)this.field_70180_af.func_187225_a(Velocity)).intValue() / 10.0f;
    }

    public boolean isArrow() {
        return (Boolean)this.field_70180_af.func_187225_a(Arrow);
    }

    public void setRotating(boolean bo) {
        this.field_70180_af.func_187227_b(Rotating, (Object)bo);
    }

    public boolean isRotating() {
        return (Boolean)this.field_70180_af.func_187225_a(Rotating);
    }

    public boolean glows() {
        return (Boolean)this.field_70180_af.func_187225_a(Glows);
    }

    public boolean is3D() {
        return (Boolean)this.field_70180_af.func_187225_a(Is3d) != false || this.isBlock();
    }

    public boolean sticksToWalls() {
        return this.is3D() && (Boolean)this.field_70180_af.func_187225_a(Sticks) != false;
    }

    public void func_70100_b_(EntityPlayer par1EntityPlayer) {
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        if (!this.getItemDisplay().func_190926_b()) {
            return new TextComponentTranslation(this.getItemDisplay().func_82833_r(), new Object[0]);
        }
        return super.func_145748_c_();
    }

    public static interface IProjectileDeadCallback {
        public boolean onImpact(EntityHolyHandGrenade var1);
    }

    public static interface IProjectileCallback {
        public boolean onImpact(EntityHolyHandGrenade var1, BlockPos var2, Entity var3);
    }
}

