/*
 * Decompiled with CFR 0.152.
 */
package jackyy.avaritiatweaks.tweaks;

import jackyy.avaritiatweaks.client.ClientProxy;
import jackyy.avaritiatweaks.config.ModConfig;
import jackyy.avaritiatweaks.packet.PacketHandler;
import jackyy.avaritiatweaks.packet.PacketToggleNoClip;
import java.util.HashSet;
import java.util.UUID;
import morph.avaritia.handler.AvaritiaEventHandler;
import morph.avaritia.init.ModItems;
import morph.avaritia.item.ItemArmorInfinity;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.PlayerSPPushOutOfBlocksEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ModEventsHandler {
    public static final HashSet<UUID> SET = new HashSet();

    @SubscribeEvent
    public void onLeftClick(PlayerInteractEvent.LeftClickBlock event) {
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        EntityPlayer player = event.getEntityPlayer();
        ItemStack stack = event.getItemStack();
        EnumFacing facing = event.getFace();
        Vec3d vec = event.getHitVec();
        if (!ModConfig.tweaks.makeWorldBreakerGreatAgain || facing == null || world.field_72995_K || stack.func_190926_b() || player.field_71075_bZ.field_75098_d) {
            return;
        }
        if (state.func_185887_b(world, pos) <= -1.0f && stack.func_77973_b() == ModItems.infinity_pickaxe) {
            if (stack.func_77978_p() != null && stack.func_77978_p().func_74767_n("hammer")) {
                ModItems.infinity_pickaxe.onBlockStartBreak(player.func_184614_ca(), pos, player);
            } else {
                ItemStack drop = block.getPickBlock(state, new RayTraceResult(vec, facing), world, pos, player);
                event.getWorld().func_175655_b(pos, false);
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), drop));
            }
        }
    }

    @SubscribeEvent
    public void armorTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            EntityPlayer player = event.player;
            if (!player.field_70170_p.field_72995_K && player.field_70170_p.func_72912_H().func_82573_f() % 100L == 0L) {
                if (ModEventsHandler.isArmorValid(player, EntityEquipmentSlot.HEAD)) {
                    ModEventsHandler.checkAndAddEffect(player, ModConfig.infinityArmor.infinityHelmetPotionEffects);
                }
                if (ModEventsHandler.isArmorValid(player, EntityEquipmentSlot.CHEST)) {
                    ModEventsHandler.checkAndAddEffect(player, ModConfig.infinityArmor.infinityChestplatePotionEffects);
                }
                if (ModEventsHandler.isArmorValid(player, EntityEquipmentSlot.LEGS)) {
                    ModEventsHandler.checkAndAddEffect(player, ModConfig.infinityArmor.infinityLeggingsPotionEffects);
                }
                if (ModEventsHandler.isArmorValid(player, EntityEquipmentSlot.FEET)) {
                    ModEventsHandler.checkAndAddEffect(player, ModConfig.infinityArmor.infinityBootsPotionEffects);
                }
            }
            if (!AvaritiaEventHandler.isInfinite((EntityPlayer)player) && !player.func_175149_v()) {
                SET.remove(player.func_110124_au());
            }
        }
    }

    @SubscribeEvent
    public void noclip(PlayerSPPushOutOfBlocksEvent event) {
        if (SET.contains(event.getEntityPlayer().func_110124_au())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void noclip(GetCollisionBoxesEvent event) {
        if (event.getEntity() instanceof EntityPlayer && SET.contains(event.getEntity().func_110124_au())) {
            event.getCollisionBoxesList().clear();
        }
    }

    @SubscribeEvent
    public void noclip(RenderBlockOverlayEvent event) {
        if (SET.contains(event.getPlayer().func_110124_au())) {
            event.setCanceled(true);
        }
    }

    private static boolean isArmorValid(EntityPlayer player, EntityEquipmentSlot slot) {
        ItemStack armor = player.func_184582_a(slot);
        return armor != ItemStack.field_190927_a && armor.func_77973_b() instanceof ItemArmorInfinity && armor.func_77978_p() != null && armor.func_77978_p().func_74762_e("enhanced") == 1;
    }

    private static void checkAndAddEffect(EntityPlayer player, String[] potions) {
        for (String potion : potions) {
            Potion effect = Potion.func_180142_b((String)potion);
            if (effect == null) continue;
            player.func_70690_d(new PotionEffect(effect, 400, 0, false, false));
        }
    }

    public static void toggleNoClip(EntityPlayer player) {
        if (ModEventsHandler.isArmorValid(player, EntityEquipmentSlot.CHEST)) {
            if (SET.contains(player.func_110124_au())) {
                SET.remove(player.func_110124_au());
                player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.avaritiatweaks.noclip.disabled", new Object[0]), true);
            } else {
                SET.add(player.func_110124_au());
                player.func_146105_b((ITextComponent)new TextComponentTranslation("msg.avaritiatweaks.noclip.enabled", new Object[0]), true);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onKeyInput(InputEvent.KeyInputEvent event) {
        if (ModConfig.infinityArmor.infinityArmorNoClip && ClientProxy.NOCLIP.func_151468_f()) {
            PacketHandler.INSTANCE.sendToServer((IMessage)new PacketToggleNoClip());
        }
    }
}

