/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth;

import java.lang.reflect.Field;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiDisconnected;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.ReconnectHelper;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.gui.MainScreen;
import technicianlp.reauth.session.SessionChecker;
import technicianlp.reauth.session.SessionStatus;
import technicianlp.reauth.util.ReflectionHelper;

@Mod.EventBusSubscriber(modid="reauth", value={Side.CLIENT})
public final class EventHandler {
    private static final Field disconnectReason = ReflectionHelper.findMcpField(GuiDisconnected.class, "field_146306_a");
    private static final Field disconnectMessage = ReflectionHelper.findMcpField(GuiDisconnected.class, "field_146304_f");

    @SubscribeEvent
    public static void onInitGui(GuiScreenEvent.InitGuiEvent.Post event) {
        GuiScreen screen = event.getGui();
        if (screen instanceof GuiMultiplayer) {
            event.getButtonList().add(new GuiButton(17325, 5, 5, 100, 20, I18n.func_135052_a((String)"reauth.gui.button", (Object[])new Object[0])));
        } else if (screen instanceof GuiMainMenu) {
            event.getButtonList().add(new GuiButton(17325, -50, -50, 20, 20, I18n.func_135052_a((String)"reauth.gui.button", (Object[])new Object[0])));
        } else if (screen instanceof GuiDisconnected) {
            EventHandler.handleDisconnectScreen(event, screen);
        } else if (screen instanceof GuiConnecting) {
            ReconnectHelper.setConnectScreen((GuiConnecting)screen);
        }
    }

    private static void handleDisconnectScreen(GuiScreenEvent.InitGuiEvent.Post event, GuiScreen screen) {
        if (I18n.func_135052_a((String)"connect.failed", (Object[])new Object[0]).equals(ReflectionHelper.getField(disconnectReason, screen)) && ReconnectHelper.getTranslationKey((ITextComponent)ReflectionHelper.getField(disconnectMessage, screen)).startsWith("disconnect.loginFailed")) {
            GuiButton menu = (GuiButton)event.getButtonList().get(0);
            Profile profile = ReAuth.profiles.getProfile();
            String retryText = profile != null ? I18n.func_135052_a((String)"reauth.retry", (Object[])new Object[]{profile.getValue("name", "Steve")}) : I18n.func_135052_a((String)"reauth.retry.disabled", (Object[])new Object[0]);
            GuiButton retryButton = new GuiButton(17325, menu.field_146128_h, menu.field_146129_i + 25, 200, 20, retryText);
            if (profile == null || !ReconnectHelper.hasConnectionInfo()) {
                retryButton.field_146124_l = false;
            }
            event.getButtonList().add(retryButton);
        }
    }

    @SubscribeEvent
    public static void onDrawGui(GuiScreenEvent.DrawScreenEvent.Post e) {
        if (e.getGui() instanceof GuiMultiplayer) {
            SessionStatus state = SessionChecker.getSessionStatus();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)state.getTranslationKey(), (Object[])new Object[0]), 110.0f, 10.0f, -1);
        }
    }

    @SubscribeEvent
    public static void action(GuiScreenEvent.ActionPerformedEvent.Post e) {
        Profile profile;
        GuiScreen screen = e.getGui();
        if ((screen instanceof GuiMainMenu || screen instanceof GuiMultiplayer) && e.getButton().field_146127_k == 17325) {
            Minecraft mc = Minecraft.func_71410_x();
            mc.func_147108_a((GuiScreen)new MainScreen(mc.field_71462_r));
        } else if (screen instanceof GuiDisconnected && e.getButton().field_146127_k == 17325 && (profile = ReAuth.profiles.getProfile()) != null) {
            ReconnectHelper.retryLogin(profile);
        }
    }

    @SubscribeEvent
    public static void action(GuiScreenEvent.ActionPerformedEvent.Pre e) {
        if (e.getGui() instanceof GuiMultiplayer && e.getButton().field_146127_k == 8 && GuiScreen.func_146272_n()) {
            SessionChecker.invalidate();
        }
    }
}

