/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.dto.xbox;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import java.lang.reflect.Type;
import org.jetbrains.annotations.Nullable;
import technicianlp.reauth.authentication.dto.ResponseObject;

public final class XboxAuthResponse
implements ResponseObject {
    @SerializedName(value="NotAfter")
    public final String validUntil;
    @SerializedName(value="Token")
    public final String token;
    @SerializedName(value="DisplayClaims")
    @JsonAdapter(value=UserhashDeserializer.class)
    public final String userhash;
    @SerializedName(value="XErr")
    @Nullable
    public final String error;

    private XboxAuthResponse() {
        this.validUntil = null;
        this.token = null;
        this.userhash = null;
        this.error = null;
    }

    @Override
    public final boolean isValid() {
        return this.error == null && this.validUntil != null && this.token != null && this.userhash != null;
    }

    @Override
    @Nullable
    public final String getError() {
        return this.error;
    }

    public final String getToken() {
        return this.token;
    }

    public static final class UserhashDeserializer
    implements JsonDeserializer<String> {
        public final String deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            try {
                JsonArray xui = json.getAsJsonObject().getAsJsonArray("xui");
                for (JsonElement claim : xui) {
                    JsonPrimitive uhs = claim.getAsJsonObject().getAsJsonPrimitive("uhs");
                    if (uhs == null) continue;
                    return uhs.getAsString();
                }
                return null;
            }
            catch (ClassCastException | IllegalStateException e) {
                throw new JsonParseException("invalid DisplayClaims format", (Throwable)e);
            }
        }
    }
}

