/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.flows.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.authentication.flows.Flow;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.FlowStage;
import technicianlp.reauth.authentication.flows.impl.util.AuthBiFunction;
import technicianlp.reauth.authentication.flows.impl.util.AuthFunction;
import technicianlp.reauth.authentication.flows.impl.util.AuthSupplier;

abstract class FlowBase
implements Flow {
    private final List<CompletableFuture<?>> stages = new ArrayList();
    private final List<FlowBase> flows = new ArrayList<FlowBase>();
    private final FlowCallback callback;
    final Executor executor;

    protected FlowBase(FlowCallback callback) {
        this.callback = callback;
        this.executor = callback.getExecutor();
    }

    final void registerDependantStages(CompletableFuture<?> ... stages) {
        Collections.addAll(this.stages, stages);
    }

    final void registerDependantFlow(FlowBase flow) {
        this.stages.add(flow.getSession());
        this.flows.add(flow);
    }

    @Override
    public void cancel() {
        this.stages.forEach(stage -> stage.cancel(true));
        this.flows.forEach(FlowBase::cancel);
        this.getSession().cancel(true);
    }

    final void onFlowComplete(SessionData data, Throwable throwable) {
        if (throwable == null) {
            if (this.hasProfile() && !this.getProfile().isDone()) {
                this.step(FlowStage.PROFILE);
            } else {
                this.step(FlowStage.FINISHED);
            }
        } else {
            this.step(FlowStage.FAILED);
        }
    }

    final void onProfileComplete() {
        if (this.getSession().isDone()) {
            this.step(FlowStage.FINISHED);
        }
    }

    final <T, U, R> BiFunction<T, U, R> wrapStep(FlowStage stage, AuthBiFunction<T, U, R> step) {
        return (t, u) -> {
            this.step(stage);
            return step.apply(t, u);
        };
    }

    final <T, R> Function<T, R> wrapStep(FlowStage stage, AuthFunction<T, R> step) {
        return t -> {
            this.step(stage);
            return step.apply(t);
        };
    }

    final <T> Supplier<T> wrapStep(FlowStage stage, AuthSupplier<T> step) {
        return () -> {
            this.step(stage);
            return step.get();
        };
    }

    final <T, R> Function<T, R> wrap(AuthFunction<T, R> step) {
        return step;
    }

    final void step(FlowStage stage) {
        this.callback.transitionStage(stage);
    }
}

