/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.flows.impl;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import technicianlp.reauth.authentication.MsAuthAPI;
import technicianlp.reauth.authentication.SessionData;
import technicianlp.reauth.authentication.dto.mojang.MojangAuthResponse;
import technicianlp.reauth.authentication.dto.mojang.ProfileResponse;
import technicianlp.reauth.authentication.dto.xbox.XboxAuthResponse;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.FlowStage;
import technicianlp.reauth.authentication.flows.impl.FlowBase;
import technicianlp.reauth.authentication.http.InvalidResponseException;
import technicianlp.reauth.authentication.http.Response;
import technicianlp.reauth.authentication.http.UnreachableServiceException;
import technicianlp.reauth.configuration.Profile;

final class XboxAuthenticationFlow
extends FlowBase {
    private static final String XSTS_ERR_TOKEN_EXPIRED = "-2146051038";
    private static final String XSTS_ERR_TOKEN_INVALID = "-2146051034";
    private final CompletableFuture<SessionData> session;
    private final CompletableFuture<Boolean> expiredToken;

    public XboxAuthenticationFlow(CompletableFuture<String> xblToken, FlowCallback callback) {
        super(callback);
        CompletionStage xstsRaw = xblToken.thenApplyAsync(this.wrapStep(FlowStage.MS_AUTH_XSTS, MsAuthAPI::authenticateXSTS), this.executor);
        this.expiredToken = ((CompletableFuture)xstsRaw).handle(this::isExpiredToken);
        CompletionStage xsts = ((CompletableFuture)xstsRaw).thenApply(this.wrap(Response::get));
        CompletionStage mojang = ((CompletableFuture)xsts).thenApplyAsync(this.wrapStep(FlowStage.MS_AUTH_MOJANG, this::authenticateMojang), this.executor);
        CompletionStage profile = ((CompletableFuture)((CompletableFuture)mojang).thenApply(MojangAuthResponse::getToken)).thenApplyAsync(this.wrapStep(FlowStage.MS_FETCH_PROFILE, MsAuthAPI::fetchProfile), this.executor);
        this.session = ((CompletableFuture)mojang).thenCombine(profile, this::makeSession);
        this.registerDependantStages(new CompletableFuture[]{xsts, mojang, profile, this.session});
    }

    private MojangAuthResponse authenticateMojang(XboxAuthResponse xsts) throws UnreachableServiceException, InvalidResponseException {
        return MsAuthAPI.authenticateMojang(xsts.token, xsts.userhash);
    }

    private SessionData makeSession(MojangAuthResponse auth, ProfileResponse profile) {
        return new SessionData(profile.name, profile.uuid, auth.token, "msa");
    }

    private boolean isExpiredToken(Response<XboxAuthResponse> response, Throwable throwable) {
        if (response.isValid() || throwable != null) {
            return false;
        }
        XboxAuthResponse rawResponse = response.getUnchecked();
        if (rawResponse != null) {
            return XSTS_ERR_TOKEN_EXPIRED.equals(rawResponse.error) || XSTS_ERR_TOKEN_INVALID.equals(rawResponse.error);
        }
        return false;
    }

    @Override
    public final CompletableFuture<SessionData> getSession() {
        return this.session;
    }

    final CompletableFuture<Boolean> hasTokenExpiredError() {
        return this.expiredToken;
    }

    @Override
    public final boolean hasProfile() {
        return false;
    }

    @Override
    public final CompletableFuture<Profile> getProfile() {
        throw new IllegalStateException("Profile creation not supported");
    }
}

