/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.http;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.http.HttpEntity;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import technicianlp.reauth.authentication.dto.RequestObject;
import technicianlp.reauth.authentication.dto.ResponseObject;
import technicianlp.reauth.authentication.http.InvalidResponseException;
import technicianlp.reauth.authentication.http.Response;
import technicianlp.reauth.authentication.http.UnreachableServiceException;

public final class HttpUtil {
    public static <R extends ResponseObject> R performFormRequest(String url, RequestObject.Form<R> form) throws UnreachableServiceException, InvalidResponseException {
        return HttpUtil.performWrappedFormRequest(url, form).get();
    }

    public static <R extends ResponseObject> Response<R> performWrappedFormRequest(String url, RequestObject.Form<R> form) throws UnreachableServiceException {
        HttpPost request = new HttpPost(url);
        List fields = form.getFields().entrySet().stream().map(e -> new BasicNameValuePair((String)e.getKey(), (String)e.getValue())).collect(Collectors.toList());
        request.setEntity((HttpEntity)new UrlEncodedFormEntity(fields, StandardCharsets.UTF_8));
        request.addHeader("Accept", "application/json");
        return HttpUtil.performRequest((HttpUriRequest)request, form.getResponseClass());
    }

    public static <R extends ResponseObject> R performJsonRequest(String url, RequestObject.JSON<R> payload) throws UnreachableServiceException, InvalidResponseException {
        return HttpUtil.performWrappedJsonRequest(url, payload).get();
    }

    public static <R extends ResponseObject> Response<R> performWrappedJsonRequest(String url, RequestObject.JSON<R> payload) throws UnreachableServiceException {
        HttpPost request = new HttpPost(url);
        request.setEntity((HttpEntity)new StringEntity(new Gson().toJson(payload), ContentType.APPLICATION_JSON));
        request.addHeader("Accept", "application/json");
        return HttpUtil.performRequest((HttpUriRequest)request, payload.getResponseClass());
    }

    public static <R extends ResponseObject> R performGetRequest(String url, String bearer, Class<R> responseType) throws UnreachableServiceException, InvalidResponseException {
        return HttpUtil.performWrappedGetRequest(url, bearer, responseType).get();
    }

    public static <R extends ResponseObject> Response<R> performWrappedGetRequest(String url, String bearer, Class<R> responseType) throws UnreachableServiceException {
        HttpGet request = new HttpGet(url);
        request.addHeader("Authorization", "Bearer " + bearer);
        request.addHeader("Accept", "application/json");
        return HttpUtil.performRequest((HttpUriRequest)request, responseType);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static <R extends ResponseObject> Response<R> performRequest(HttpUriRequest request, Class<R> responseType) throws UnreachableServiceException {
        try (CloseableHttpClient client = HttpClients.createDefault();){
            CloseableHttpResponse httpResponse = client.execute(request);
            int statusCode = httpResponse.getStatusLine().getStatusCode();
            ResponseObject response = null;
            HttpEntity httpEntity = httpResponse.getEntity();
            if (httpEntity != null) {
                InputStreamReader reader = new InputStreamReader(httpEntity.getContent(), StandardCharsets.UTF_8);
                response = (ResponseObject)new Gson().fromJson((Reader)reader, responseType);
            }
            Response<Object> response2 = new Response<Object>(statusCode, response);
            return response2;
        }
        catch (IOException e) {
            throw new UnreachableServiceException("Cannot reach server", e);
        }
        catch (JsonParseException | IllegalStateException e) {
            throw new UnreachableServiceException("Server is talking nonsense", e);
        }
    }
}

