/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.http.server;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.http.server.CodeHandler;
import technicianlp.reauth.authentication.http.server.PageWriter;
import technicianlp.reauth.authentication.http.server.ResourcesHandler;

public final class AuthenticationCodeServer {
    private final Runnable stopServer;
    private final Executor executor;
    private boolean running = true;

    public AuthenticationCodeServer(int port, String loginUrl, CompletableFuture<String> codeFuture, Executor executor) throws IOException, NoClassDefFoundError {
        HttpServer server = HttpServer.create(new InetSocketAddress(InetAddress.getLoopbackAddress(), port), 0);
        this.executor = executor;
        server.setExecutor(executor);
        PageWriter writer = new PageWriter(loginUrl);
        server.createContext("/", new CodeHandler(writer, codeFuture));
        server.createContext("/res/", new ResourcesHandler(writer));
        codeFuture.whenCompleteAsync((v, t) -> this.stop(), executor);
        ReAuth.log.info("Starting local endpoint");
        server.start();
        ReAuth.log.info("Started local endpoint");
        this.stopServer = () -> {
            ReAuth.log.info("Stopping local endpoint");
            server.stop(1);
            ReAuth.log.info("Stopped local endpoint");
        };
    }

    public final synchronized void stop() {
        if (this.running) {
            this.executor.execute(this.stopServer);
            this.running = false;
        }
    }
}

