/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.http.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.io.IOUtils;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.http.server.Handler;
import technicianlp.reauth.authentication.http.server.HttpStatus;
import technicianlp.reauth.authentication.http.server.PageWriter;
import technicianlp.reauth.authentication.http.server.Response;

final class CodeHandler
extends Handler {
    private final CompletableFuture<String> codeFuture;

    CodeHandler(PageWriter writer, CompletableFuture<String> codeFuture) {
        super(writer);
        this.codeFuture = codeFuture;
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        String method = exchange.getRequestMethod().toUpperCase(Locale.ROOT);
        Response response = "POST".equals(method) ? this.handlePostRequest(exchange) : ("HEAD".equals(method) || "GET".equals(method) ? new Response(HttpStatus.Method_Not_Allowed).setHeader("Allow", "POST") : new Response(HttpStatus.Not_Implemented));
        this.sendResponse(exchange, response);
    }

    private Response handlePostRequest(HttpExchange exchange) throws IOException {
        String contentType = exchange.getRequestHeaders().getFirst("Content-Type");
        if (!contentType.startsWith("application/x-www-form-urlencoded")) {
            return new Response(HttpStatus.Unsupported_Media_Type);
        }
        String body = IOUtils.toString((InputStream)exchange.getRequestBody(), (Charset)StandardCharsets.UTF_8);
        Map<String, String> formFields = this.parseFormFields(body);
        if (formFields.containsKey("code")) {
            ReAuth.log.info("Received Microsoft Authentication Code");
            this.codeFuture.complete(formFields.get("code"));
            return new Response(HttpStatus.OK).setContent("text/html; charset=UTF-8", this.pageWriter.createSuccessResponsePage());
        }
        String error = formFields.getOrDefault("error", "unknown");
        ReAuth.log.error("Received Error from Microsoft Authentication: " + error);
        return new Response(HttpStatus.Bad_Request).setContent("text/html; charset=UTF-8", this.pageWriter.createErrorResponsePage(error));
    }

    private Map<String, String> parseFormFields(String formUrlEncoded) {
        HashMap<String, String> formFields = new HashMap<String, String>();
        String[] fields = formUrlEncoded.split("&");
        try {
            for (String field : fields) {
                if (field.isEmpty()) continue;
                String key = field;
                String value = "";
                int delimiter = field.indexOf(61);
                if (delimiter != -1) {
                    key = field.substring(0, delimiter);
                    value = field.substring(delimiter + 1);
                }
                formFields.putIfAbsent(URLDecoder.decode(key, "UTF-8"), URLDecoder.decode(value, "UTF-8"));
            }
        }
        catch (UnsupportedEncodingException exception) {
            throw new RuntimeException("UTF-8 unsupported", exception);
        }
        return formFields;
    }
}

