/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.authentication.http.server;

import com.sun.net.httpserver.HttpExchange;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.util.Locale;
import technicianlp.reauth.authentication.http.server.AuthenticationCodeServer;
import technicianlp.reauth.authentication.http.server.Handler;
import technicianlp.reauth.authentication.http.server.HttpStatus;
import technicianlp.reauth.authentication.http.server.PageWriter;
import technicianlp.reauth.authentication.http.server.Response;

final class ResourcesHandler
extends Handler {
    ResourcesHandler(PageWriter writer) {
        super(writer);
    }

    @Override
    public final void handle(HttpExchange exchange) throws IOException {
        String method = exchange.getRequestMethod().toUpperCase(Locale.ROOT);
        Response response = method.equals("GET") || method.equals("HEAD") ? this.handleResourceGet(exchange.getRequestURI().getPath()) : (method.equals("POST") ? new Response(HttpStatus.Method_Not_Allowed).setHeader("Allow", "GET, HEAD") : new Response(HttpStatus.Not_Implemented));
        this.sendResponse(exchange, response);
    }

    private Response handleResourceGet(String path) throws IOException {
        String contentType = null;
        String resource = null;
        if ("/res/icon.png".equals(path)) {
            contentType = "image/png";
            resource = "/resources/reauth/icon.png";
        } else if ("/res/logo.png".equals(path)) {
            contentType = "image/png";
            resource = "/resources/reauth/logo.png";
        }
        if (resource != null) {
            Throwable throwable = null;
            try (InputStream is = AuthenticationCodeServer.class.getResourceAsStream(resource);){
                if (is != null) {
                    ByteBuffer buffer = ByteBuffer.allocate(32768);
                    Channels.newChannel(is).read(buffer);
                    Response response = new Response(HttpStatus.OK).setContent(contentType, buffer);
                    return response;
                }
                try {
                    throw new FileNotFoundException("Resource " + resource + " is unavailable");
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
        return new Response(HttpStatus.Not_Found);
    }
}

