/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.configuration;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import technicianlp.reauth.configuration.Config;
import technicianlp.reauth.configuration.Profile;

public final class ProfileList {
    private static final String PROFILES_CATEGORY = "profiles.";
    private static final List<String> propertyOrder = ImmutableList.of((Object)"type", (Object)"name", (Object)"uuid", (Object)"username", (Object)"xbl-token", (Object)"password", (Object)"refresh-token", (Object)"key", (Object)"salt");
    private final Config config;
    private ConfigCategory profilesCategory = null;

    ProfileList(Config config) {
        this.config = config;
    }

    final void loadConfig(ConfigCategory profilesCategory) {
        this.profilesCategory = profilesCategory;
        if (!profilesCategory.isEmpty()) {
            profilesCategory.clear();
        }
        profilesCategory.getChildren().forEach(this::correctProfile);
        this.config.save();
    }

    public final void storeProfile(Profile profile) {
        if (profile.isLoaded()) {
            return;
        }
        Configuration configuration = this.config.getConfig();
        ConfigCategory oldCategory = (ConfigCategory)Iterables.getFirst((Iterable)this.profilesCategory.getChildren(), null);
        if (oldCategory != null) {
            configuration.removeCategory(oldCategory);
        }
        ConfigCategory category = configuration.getCategory(this.findNewProfileName());
        Map<String, String> profileData = profile.getConfig();
        profileData.forEach((key, value) -> configuration.get(category.getQualifiedName(), key, "").set(value));
        category.setPropertyOrder(new ArrayList<String>(propertyOrder));
        this.saveProfiles();
    }

    public final Profile getProfile() {
        ConfigCategory category = (ConfigCategory)Iterables.getFirst((Iterable)this.profilesCategory.getChildren(), null);
        if (category == null) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>();
        category.forEach((k, v) -> values.put((String)k, v.getString()));
        String profileType = values.getOrDefault("type", "none");
        if (!"none".equals(profileType)) {
            return new Profile(values, true);
        }
        return null;
    }

    public final ConfigCategory getProfilesCategory() {
        return this.profilesCategory;
    }

    final Profile createProfile(Map<String, String> data) {
        return new Profile(data, false);
    }

    private void correctProfile(ConfigCategory profile) {
        ArrayList<Property> newProps = new ArrayList<Property>(0);
        Iterator iterator = profile.values().iterator();
        while (iterator.hasNext()) {
            Property entry2 = (Property)iterator.next();
            if (entry2.getType() != Property.Type.STRING || entry2.isList()) {
                iterator.remove();
                String value = entry2.isList() ? Arrays.toString(entry2.getStringList()) : entry2.getString();
                Property property = new Property(entry2.getName(), value, Property.Type.STRING);
                property.setDefaultValue("");
                newProps.add(property);
                continue;
            }
            entry2.setDefaultValue("");
        }
        newProps.forEach(entry -> profile.put(entry.getName(), entry));
        profile.setPropertyOrder(new ArrayList<String>(propertyOrder));
    }

    private void saveProfiles() {
        this.config.save();
    }

    private String findNewProfileName() {
        Configuration configuration = this.config.getConfig();
        int i = 1;
        String nameBase = "profiles.profile";
        while (configuration.hasCategory(nameBase + i)) {
            ++i;
        }
        return nameBase + i;
    }
}

