/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.crypto;

import java.security.SecureRandom;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.impl.util.Futures;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.crypto.EncryptionAutomatic;
import technicianlp.reauth.crypto.EncryptionNone;
import technicianlp.reauth.crypto.JceWorkaround;
import technicianlp.reauth.crypto.PkceChallenge;
import technicianlp.reauth.crypto.ProfileEncryption;

public final class Crypto {
    private static String configPath = "";

    public static CompletableFuture<ProfileEncryption> getProfileEncryption(Profile profile, FlowCallback callback) {
        switch (profile.getValue("key")) {
            case "auto": {
                return CompletableFuture.supplyAsync(() -> new EncryptionAutomatic(configPath, profile.getValue("salt")), callback.getExecutor());
            }
            case "none": {
                return CompletableFuture.completedFuture(new EncryptionNone());
            }
        }
        return Futures.failed(new IllegalArgumentException("Unknown Encryption Type"));
    }

    public static CompletableFuture<ProfileEncryption> newEncryption(Executor executor) {
        return CompletableFuture.supplyAsync(() -> new EncryptionAutomatic(configPath), executor);
    }

    public static byte[] randomBytes(int length) {
        byte[] salt = new byte[length];
        new SecureRandom().nextBytes(salt);
        return salt;
    }

    public static PkceChallenge createPkceChallenge() {
        return new PkceChallenge();
    }

    public static void init() {
        JceWorkaround.ensureUnlimitedCryptography();
    }

    public static void updateConfigPath(String configPath) {
        Crypto.configPath = configPath;
    }
}

