/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.crypto;

import java.lang.reflect.Field;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Map;
import javax.crypto.Cipher;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.crypto.CryptoException;
import technicianlp.reauth.util.ReflectionHelper;

public final class JceWorkaround {
    public static void ensureUnlimitedCryptography() {
        try {
            if (Cipher.getMaxAllowedKeyLength("AES") != Integer.MAX_VALUE) {
                ReAuth.log.warn("Cryptography is restricted in this Java installation");
                ReAuth.log.warn("Please complain to Mojang for shipping a 5 year old Java version");
                JceWorkaround.removeCryptographyRestrictions();
                if (Cipher.getMaxAllowedKeyLength("AES") != Integer.MAX_VALUE) {
                    ReAuth.log.error("Failed to remove cryptography restriction");
                } else {
                    ReAuth.log.info("Cryptography restriction removed successfully");
                }
            }
        }
        catch (NoSuchAlgorithmException e) {
            throw new CryptoException("AES unavailable", e);
        }
    }

    private static void removeCryptographyRestrictions() {
        try {
            Class<?> jceSecurity = Class.forName("javax.crypto.JceSecurity");
            Field isRestricted = ReflectionHelper.findField(jceSecurity, "isRestricted");
            ReflectionHelper.unlockFinalField(isRestricted);
            Field defaultPolicy = ReflectionHelper.findField(jceSecurity, "defaultPolicy");
            Class<?> cryptoPermissions = Class.forName("javax.crypto.CryptoPermissions");
            Field perms = ReflectionHelper.findField(cryptoPermissions, "perms");
            Class<?> cryptoAllPermission = Class.forName("javax.crypto.CryptoAllPermission");
            Field instance = ReflectionHelper.findField(cryptoAllPermission, "INSTANCE");
            ReflectionHelper.setField(isRestricted, null, false);
            PermissionCollection permissionCollection = (PermissionCollection)ReflectionHelper.getField(defaultPolicy, null);
            ((Map)ReflectionHelper.getField(perms, permissionCollection)).clear();
            permissionCollection.add((Permission)ReflectionHelper.getField(instance, null));
        }
        catch (Exception e) {
            ReAuth.log.error("Exception removing cryptography restrictions", (Throwable)e);
        }
    }
}

