/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.gui;

import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import org.lwjgl.opengl.GL11;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.flows.AuthorizationCodeFlow;
import technicianlp.reauth.authentication.flows.DeviceCodeFlow;
import technicianlp.reauth.authentication.flows.Flow;
import technicianlp.reauth.authentication.flows.FlowCallback;
import technicianlp.reauth.authentication.flows.FlowStage;
import technicianlp.reauth.configuration.Profile;
import technicianlp.reauth.gui.AbstractScreen;
import technicianlp.reauth.session.SessionHelper;
import technicianlp.reauth.util.ReflectionHelper;

public final class FlowScreen
extends AbstractScreen
implements FlowCallback {
    private static final Method openURL = ReflectionHelper.findMcpMethod(GuiScreen.class, "func_175282_a", Void.TYPE, URI.class);
    private Flow flow;
    private FlowStage stage = FlowStage.INITIAL;
    private String[] formatArgs = new String[0];

    public FlowScreen(GuiScreen background) {
        super("reauth.gui.title.flow", background);
    }

    public final void setFlow(Flow flow) {
        this.flow = flow;
        flow.getSession().thenAccept(SessionHelper::setSession);
        if (flow.hasProfile()) {
            flow.getProfile().whenComplete(this::profileComplete);
        }
    }

    @Override
    public final void func_73866_w_() {
        DeviceCodeFlow flow;
        super.func_73866_w_();
        int buttonWidth = 196;
        int buttonWidthH = buttonWidth / 2;
        this.formatArgs = new String[0];
        if (this.stage == FlowStage.MS_AWAIT_AUTH_CODE && this.flow instanceof AuthorizationCodeFlow) {
            this.getClass();
            this.func_189646_b(new GuiButton(2, this.centerX - buttonWidthH, this.baseY + 175 - 42, buttonWidth, 20, I18n.func_135052_a((String)"reauth.msauth.button.browser", (Object[])new Object[0])));
        } else if (this.stage == FlowStage.MS_POLL_DEVICE_CODE && this.flow instanceof DeviceCodeFlow && CompletableFuture.allOf((flow = (DeviceCodeFlow)this.flow).getLoginUrl(), flow.getCode()).isDone()) {
            this.getClass();
            this.func_189646_b(new GuiButton(3, this.centerX - buttonWidthH, this.baseY + 175 - 42, buttonWidth, 20, I18n.func_135052_a((String)"reauth.msauth.button.browser", (Object[])new Object[0])));
            this.formatArgs = new String[]{flow.getLoginUrl().join(), flow.getCode().join()};
        }
    }

    @Override
    public final void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        String text = I18n.func_135052_a((String)this.stage.getRawName(), (Object[])this.formatArgs);
        String[] lines = text.split("\\\\n");
        int height = lines.length * 9;
        for (String s : lines) {
            if (!s.startsWith("$")) continue;
            height += 9;
        }
        int y = this.centerY - height / 2;
        for (String line : lines) {
            if (line.startsWith("$")) {
                line = line.substring(1);
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
                this.field_146289_q.func_175063_a(line, (float)(this.centerX - this.field_146289_q.func_78256_a(line)) / 2.0f, (float)y / 2.0f, -1);
                y += 18;
                GL11.glPopMatrix();
                continue;
            }
            this.field_146289_q.func_175063_a(line, (float)(this.centerX - this.field_146289_q.func_78256_a(line) / 2), (float)y, -1);
            y += 9;
        }
    }

    private void profileComplete(Profile profile, Throwable throwable) {
        if (throwable == null) {
            ReAuth.profiles.storeProfile(profile);
            ReAuth.log.info("Profile saved successfully");
        } else {
            ReAuth.log.error("Profile failed to save", throwable);
        }
    }

    @Override
    public final void func_146281_b() {
        super.func_146281_b();
        if (this.stage != FlowStage.FINISHED) {
            this.flow.cancel();
        }
    }

    @Override
    public final void transitionStage(FlowStage newStage) {
        this.stage = newStage;
        ReAuth.log.info(this.stage.getLogLine());
        this.func_146280_a(Minecraft.func_71410_x(), this.field_146294_l, this.field_146295_m);
        if (newStage == FlowStage.MS_AWAIT_AUTH_CODE && this.flow instanceof AuthorizationCodeFlow) {
            try {
                URI uri = new URI(((AuthorizationCodeFlow)this.flow).getLoginUrl());
                ReflectionHelper.callMethod(openURL, this, uri);
            }
            catch (URISyntaxException e) {
                ReAuth.log.error("Failed to open page", (Throwable)e);
            }
        } else if (newStage == FlowStage.FINISHED) {
            this.requestClose(true);
        }
    }

    @Override
    public final Executor getExecutor() {
        return ReAuth.executor;
    }

    @Override
    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 2 && this.flow instanceof AuthorizationCodeFlow) {
            try {
                URI uri = new URI(((AuthorizationCodeFlow)this.flow).getLoginUrl());
                ReflectionHelper.callMethod(openURL, this, uri);
            }
            catch (URISyntaxException e) {
                ReAuth.log.error("Browser button failed", (Throwable)e);
            }
        } else if (button.field_146127_k == 3 && this.flow instanceof DeviceCodeFlow) {
            try {
                CompletableFuture<String> loginUrl = ((DeviceCodeFlow)this.flow).getLoginUrl();
                if (loginUrl.isDone()) {
                    ReflectionHelper.callMethod(openURL, this, new URI(loginUrl.join()));
                }
            }
            catch (URISyntaxException e) {
                ReAuth.log.error("Browser button failed", (Throwable)e);
            }
        }
    }
}

