/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.session;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import net.minecraft.client.Minecraft;
import net.minecraft.util.Session;
import technicianlp.reauth.ReAuth;
import technicianlp.reauth.authentication.YggdrasilAPI;
import technicianlp.reauth.authentication.http.UnreachableServiceException;
import technicianlp.reauth.session.SessionStatus;

public final class SessionChecker {
    private static final long cacheTime = 300000L;
    private static SessionStatus status = SessionStatus.UNKNOWN;
    private static long lastCheck = 0L;

    public static SessionStatus getSessionStatus() {
        if (lastCheck + 300000L < System.currentTimeMillis()) {
            SessionChecker.status = SessionStatus.UNKNOWN;
        }
        if (SessionChecker.status == SessionStatus.UNKNOWN) {
            SessionChecker.status = SessionStatus.REFRESHING;
            lastCheck = System.currentTimeMillis();
            CompletableFuture<Session> session = CompletableFuture.completedFuture(Minecraft.func_71410_x().func_110432_I());
            CompletionStage token = session.thenApply(Session::func_148254_d);
            CompletionStage uuid = session.thenApply(Session::func_148255_b);
            ((CompletableFuture)((CompletableFuture)token).thenCombineAsync(uuid, SessionChecker::getSessionStatus, (Executor)ReAuth.executor)).thenAccept(status -> {
                SessionChecker.status = status;
            });
        }
        return SessionChecker.status;
    }

    public static void invalidate() {
        status = SessionStatus.UNKNOWN;
    }

    private static SessionStatus getSessionStatus(String accessToken, String uuid) {
        try {
            return YggdrasilAPI.validate(accessToken, uuid) ? SessionStatus.VALID : SessionStatus.INVALID;
        }
        catch (UnreachableServiceException e) {
            ReAuth.log.error("Failed to check session validity", (Throwable)e);
            return SessionStatus.ERROR;
        }
    }
}

