/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public final class ReflectionHelper {
    private static final Field fieldModifiers = ReflectionHelper.findField(Field.class, "modifiers");

    public static Method findMethod(Class<?> clz, String name, Class<?> ... parameterTypes) {
        try {
            Method method = clz.getDeclaredMethod(name, parameterTypes);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException exception) {
            throw new UncheckedReflectiveOperationException("Unable to find Method: " + name, exception);
        }
    }

    public static Method findMcpMethod(Class<?> clz, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        try {
            return ObfuscationReflectionHelper.findMethod(clz, (String)name, returnType, (Class[])parameterTypes);
        }
        catch (ReflectionHelper.UnableToFindMethodException ignored) {
            throw new UncheckedReflectiveOperationException("Unable to find MCP Method: " + name);
        }
    }

    public static <T> T callMethod(Method method, Object target, Object ... args) {
        try {
            return (T)method.invoke(target, args);
        }
        catch (ReflectiveOperationException exception) {
            throw new UncheckedReflectiveOperationException("Failed reflective Method call", exception);
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> clz, Class<?> ... parameterTypes) {
        try {
            Constructor<T> constructor = clz.getDeclaredConstructor(parameterTypes);
            constructor.setAccessible(true);
            return constructor;
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Unable to find Constructor", exception);
        }
    }

    public static <T> T callConstructor(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (ReflectiveOperationException exception) {
            throw new RuntimeException("Failed reflective Constructor call", exception);
        }
    }

    public static Field findField(Class<?> clz, String name) {
        try {
            Field field = clz.getDeclaredField(name);
            field.setAccessible(true);
            return field;
        }
        catch (ReflectiveOperationException exception) {
            throw new UncheckedReflectiveOperationException("Unable to find Field: " + name, exception);
        }
    }

    public static <T> Field findMcpField(Class<? super T> clz, String name) {
        try {
            return ObfuscationReflectionHelper.findField(clz, (String)name);
        }
        catch (ReflectionHelper.UnableToFindFieldException ignored) {
            throw new UncheckedReflectiveOperationException("Unable to find MCP Field: " + name);
        }
    }

    public static void unlockFinalField(Field field) {
        try {
            fieldModifiers.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        }
        catch (ReflectiveOperationException exception) {
            throw new UncheckedReflectiveOperationException("Unable to unlock final field", exception);
        }
    }

    public static void setField(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (ReflectiveOperationException exception) {
            throw new UncheckedReflectiveOperationException("Failed Reflective set", exception);
        }
    }

    public static <T> T getField(Field field, Object target) {
        try {
            return (T)field.get(target);
        }
        catch (ReflectiveOperationException exception) {
            throw new UncheckedReflectiveOperationException("Failed Reflective get", exception);
        }
    }

    public static class UncheckedReflectiveOperationException
    extends RuntimeException {
        public UncheckedReflectiveOperationException(String message, ReflectiveOperationException cause) {
            super(message, cause);
        }

        public UncheckedReflectiveOperationException(String message) {
            super(message);
        }
    }
}

