/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.block;

import CoroUtil.config.ConfigCoroUtil;
import CoroUtil.config.ConfigCoroUtilAdvanced;
import CoroUtil.config.ConfigDynamicDifficulty;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CommonProxy;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class TileEntityRepairingBlock
extends TileEntity {
    private IBlockState orig_blockState;
    private float orig_hardness = 1.0f;
    private float orig_explosionResistance = 1.0f;
    private long timeToRepairAt = 0L;

    public void updateScheduledTick() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.orig_blockState == null || this.orig_blockState == this.func_145838_q().func_176223_P()) {
                CULog.dbg("invalid state for repairing block, removing, orig_blockState: " + this.orig_blockState + " vs " + this.func_145838_q().func_176223_P());
                this.func_145831_w().func_175656_a(this.func_174877_v(), Blocks.field_150350_a.func_176223_P());
            } else if (this.field_145850_b.func_82737_E() > this.timeToRepairAt || ConfigCoroUtilAdvanced.repairBlockNextRandomTick) {
                AxisAlignedBB aabb = this.func_145838_q().func_176223_P().func_185900_c((IBlockAccess)this.func_145831_w(), this.func_174877_v());
                aabb = Block.field_185505_j;
                aabb = aabb.func_186670_a(this.func_174877_v());
                List listTest = this.func_145831_w().func_72872_a(EntityLivingBase.class, aabb);
                if (listTest.size() == 0) {
                    this.restoreBlock();
                }
            }
        }
    }

    public void onLoad() {
        super.onLoad();
    }

    public void restoreBlock() {
        this.func_145831_w().func_175656_a(this.func_174877_v(), this.orig_blockState);
        for (int x = -1; x <= 1; ++x) {
            for (int y = -1; y <= 1; ++y) {
                for (int z = -1; z <= 1; ++z) {
                    BlockPos posFix = this.field_174879_c.func_177982_a(x, y, z);
                    IBlockState state = this.field_145850_b.func_180495_p(posFix);
                    if (!(state.func_177230_c() instanceof BlockLeaves)) continue;
                    try {
                        this.field_145850_b.func_180501_a(posFix, state.func_177226_a((IProperty)BlockLeaves.field_176236_b, (Comparable)Boolean.valueOf(false)), 4);
                        continue;
                    }
                    catch (Exception ex) {
                        if (!ConfigCoroUtil.useLoggingDebug) continue;
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    public void setBlockData(IBlockState state) {
        this.orig_blockState = state;
    }

    public IBlockState getOrig_blockState() {
        return this.orig_blockState;
    }

    public NBTTagCompound func_189515_b(NBTTagCompound var1) {
        if (this.orig_blockState != null) {
            String str = ((ResourceLocation)Block.field_149771_c.func_177774_c((Object)this.orig_blockState.func_177230_c())).toString();
            var1.func_74778_a("orig_blockName", str);
            var1.func_74768_a("orig_blockMeta", this.orig_blockState.func_177230_c().func_176201_c(this.orig_blockState));
        }
        var1.func_74772_a("timeToRepairAt", this.timeToRepairAt);
        var1.func_74776_a("orig_hardness", this.orig_hardness);
        var1.func_74776_a("orig_explosionResistance", this.orig_explosionResistance);
        return super.func_189515_b(var1);
    }

    public void func_145839_a(NBTTagCompound var1) {
        super.func_145839_a(var1);
        this.timeToRepairAt = var1.func_74763_f("timeToRepairAt");
        try {
            Block block = Block.func_149684_b((String)var1.func_74779_i("orig_blockName"));
            if (block != null) {
                int meta = var1.func_74762_e("orig_blockMeta");
                this.orig_blockState = block.func_176203_a(meta);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.orig_blockState = Blocks.field_150350_a.func_176223_P();
        }
        this.orig_hardness = var1.func_74760_g("orig_hardness");
        this.orig_explosionResistance = var1.func_74760_g("orig_explosionResistance");
    }

    public void func_145843_s() {
        super.func_145843_s();
    }

    public static TileEntityRepairingBlock replaceBlockAndBackup(World world, BlockPos pos) {
        return TileEntityRepairingBlock.replaceBlockAndBackup(world, pos, ConfigDynamicDifficulty.ticksToRepairBlock);
    }

    public static TileEntityRepairingBlock replaceBlockAndBackup(World world, BlockPos pos, int ticksToRepair) {
        IBlockState oldState = world.func_180495_p(pos);
        float oldHardness = oldState.func_185887_b(world, pos);
        float oldExplosionResistance = 1.0f;
        try {
            oldExplosionResistance = oldState.func_177230_c().getExplosionResistance(world, pos, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        world.func_175656_a(pos, CommonProxy.blockRepairingBlock.func_176223_P());
        TileEntity tEnt = world.func_175625_s(pos);
        if (tEnt instanceof TileEntityRepairingBlock) {
            IBlockState state = world.func_180495_p(pos);
            TileEntityRepairingBlock repairing = (TileEntityRepairingBlock)tEnt;
            repairing.setBlockData(oldState);
            repairing.setOrig_hardness(oldHardness);
            repairing.setOrig_explosionResistance(oldExplosionResistance);
            repairing.timeToRepairAt = world.func_82737_E() + (long)ticksToRepair;
            return (TileEntityRepairingBlock)tEnt;
        }
        CULog.dbg("failed to set repairing block for pos: " + pos);
        return null;
    }

    public float getOrig_hardness() {
        return this.orig_hardness;
    }

    public void setOrig_hardness(float orig_hardness) {
        this.orig_hardness = orig_hardness;
    }

    public float getOrig_explosionResistance() {
        return this.orig_explosionResistance;
    }

    public void setOrig_explosionResistance(float orig_explosionResistance) {
        this.orig_explosionResistance = orig_explosionResistance;
    }
}

