/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.bt;

import CoroUtil.OldUtil;
import CoroUtil.bt.AIBTAgent;
import CoroUtil.pathfinding.IPFCallback;
import CoroUtil.pathfinding.PFCallbackItem;
import CoroUtil.pathfinding.PFJobData;
import CoroUtil.pathfinding.PFQueue;
import CoroUtil.util.BlockCoord;
import CoroUtil.util.Vec3;
import java.util.ArrayList;
import net.minecraft.entity.Entity;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;

public class BlackboardBase
implements IPFCallback {
    public AIBTAgent agent;
    public Vec3 posMoveTo;
    public ArrayList<PFCallbackItem> listCallbackPaths = new ArrayList();
    public Path pathMoveToPath;
    public Path pathMoveToPathFar;
    public MutableBoolean isWaitingForPath = new MutableBoolean(false);
    public MutableBoolean isPathReceived = new MutableBoolean(false);
    private int targetID;
    private Entity target;
    public MutableInt moveCondition = new MutableInt(0);
    public MutableBoolean isPathSafe = new MutableBoolean(true);
    public MutableBoolean isLongPath = new MutableBoolean(true);
    public MutableBoolean isClosePath = new MutableBoolean(true);
    public MutableBoolean isSafeOrClosePath = new MutableBoolean(true);
    public MutableBoolean isMoving = new MutableBoolean(true);
    public MutableBoolean isFighting = new MutableBoolean(false);
    public MutableBoolean shouldTrySurvival = new MutableBoolean(false);
    public MutableBoolean shouldChaseTarget = new MutableBoolean(false);
    public MutableBoolean shouldWander = new MutableBoolean(false);
    public MutableBoolean isUsingMelee = new MutableBoolean(false);
    public MutableBoolean isUsingRanged = new MutableBoolean(false);
    public MutableBoolean shouldFollowOrders = new MutableBoolean(false);
    public BlockCoord fleeToCoords = new BlockCoord(0, 0, 0);
    public long lastTickSafetyCheck = 0L;
    public MutableInt distMed = new MutableInt(18);
    public MutableInt distClose = new MutableInt(3);
    public Entity lastFleeTarget;
    public long lastTimeRequestedPFThreaded = 0L;
    public long PFThreadedTimeout = 5000L;
    public MutableBoolean canFlyPath = new MutableBoolean(false);
    public MutableBoolean canSwimPath = new MutableBoolean(false);
    public MutableBoolean canFlyStraitToTarget = new MutableBoolean(false);

    public BlackboardBase(AIBTAgent parAgent) {
        this.agent = parAgent;
    }

    public Entity getTarget() {
        Entity ent;
        if (this.target != null) {
            return this.target;
        }
        if (this.targetID != -1 && (ent = this.agent.ent.field_70170_p.func_73045_a(this.targetID)) != null) {
            this.setTarget(ent);
        }
        return this.target;
    }

    public void setTarget(int parID) {
        Entity ent = this.agent.ent.field_70170_p.func_73045_a(parID);
        if (ent != null) {
            this.setTarget(ent);
        }
    }

    public void setTarget(Entity parTarget) {
        this.target = parTarget;
        this.targetID = parTarget != null ? parTarget.func_145782_y() : -1;
    }

    public void trackTarget() {
        this.trackTarget(false);
    }

    public void trackTarget(boolean resetPathData) {
        if (this.target != null) {
            this.setMoveTo(new Vec3(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v), resetPathData);
        }
    }

    public void setMoveAndPathTo(Vec3 parMoveTo) {
        this.setMoveTo(parMoveTo, true);
    }

    public void setMoveTo(Vec3 parMoveTo) {
        this.setMoveTo(parMoveTo, false);
    }

    public void setMoveTo(Vec3 parMoveTo, boolean resetPathData) {
        if (!this.agent.tamable.shouldStayStill()) {
            this.posMoveTo = parMoveTo;
            if (resetPathData) {
                this.pathMoveToPath = null;
                this.pathMoveToPathFar = null;
                this.isWaitingForPath.setValue(false);
                this.isPathReceived.setValue(false);
            }
        }
    }

    public void setPathFar(Path parPath) {
        this.pathMoveToPathFar = parPath;
        this.isWaitingForPath.setValue(false);
        this.isPathReceived.setValue(true);
    }

    public void requestPathFar(Vec3 parPos, int pathRange) {
        if (this.canFlyPath.getValue().booleanValue() || this.canSwimPath.getValue().booleanValue()) {
            PFJobData job = new PFJobData((Entity)this.agent.ent, MathHelper.func_76128_c((double)parPos.xCoord), MathHelper.func_76128_c((double)parPos.yCoord), MathHelper.func_76128_c((double)parPos.zCoord), (float)pathRange);
            job.callback = this;
            job.canUseLadder = true;
            job.useFlyPathfinding = this.canFlyPath.getValue();
            job.useSwimPathfinding = this.canSwimPath.getValue();
            PFQueue.tryPath(job);
        } else {
            PFQueue.tryPath((Entity)this.agent.ent, MathHelper.func_76128_c((double)parPos.xCoord), MathHelper.func_76128_c((double)parPos.yCoord), MathHelper.func_76128_c((double)parPos.zCoord), pathRange, 0, this);
        }
        this.isWaitingForPath.setValue(true);
        this.isPathReceived.setValue(false);
        this.lastTimeRequestedPFThreaded = System.currentTimeMillis();
    }

    public void resetReceived() {
        this.isPathReceived.setValue(false);
        this.isWaitingForPath.setValue(false);
    }

    @Override
    public void pfComplete(PFCallbackItem ci) {
        this.listCallbackPaths.add(ci);
    }

    @Override
    public void manageCallbackQueue() {
        ArrayList<PFCallbackItem> list = this.getQueue();
        try {
            for (int i = 0; i < list.size(); ++i) {
                PFCallbackItem item = list.get(i);
                if (item.ent.field_70128_L || !OldUtil.chunkExists(item.ent.field_70170_p, MathHelper.func_76128_c((double)(item.ent.field_70165_t / 16.0)), MathHelper.func_76128_c((double)(item.ent.field_70161_v / 16.0)))) continue;
                this.setPathFar(item.pe);
            }
        }
        catch (Exception ex) {
            System.out.println("Crash in Epoch AI Blackboard for PF Callback");
            ex.printStackTrace();
        }
        this.listCallbackPaths.clear();
    }

    @Override
    public ArrayList<PFCallbackItem> getQueue() {
        return this.listCallbackPaths;
    }
}

