/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.difficulty;

import CoroUtil.ai.ITaskInitializer;
import CoroUtil.difficulty.DynamicDifficulty;
import CoroUtil.difficulty.EquipmentForDifficulty;
import CoroUtil.difficulty.buffs.BuffBase;
import CoroUtil.difficulty.data.DataCmod;
import CoroUtil.difficulty.data.DeserializerAllJson;
import CoroUtil.difficulty.data.cmods.CmodInventory;
import CoroUtil.difficulty.data.cmods.CmodInventoryDifficultyScaled;
import CoroUtil.difficulty.data.cmods.CmodInventoryEntry;
import CoroUtil.forge.CULog;
import CoroUtil.forge.CoroUtil;
import com.google.gson.JsonArray;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraftforge.event.entity.living.LivingDeathEvent;

public class UtilEntityBuffs {
    public static HashMap<String, BuffBase> lookupBuffs = new HashMap();
    public static String dataEntityBuffed = "CoroAI_HW_Buffed";
    public static String dataEntityBuffDiceRolled = "CoroAI_HW_BuffDiceRolled";
    public static String dataEntityBuffed_Difficulty = "CoroAI_HW_Difficulty";
    public static String dataEntityBuffed_PlayerSpawnedFor = "CoroAI_HW_PlayerSpawnedFor";
    public static String dataEntityBuffed_LastTimePathfindLongDist = "CoroAI_LastTimePathfindLongDist";
    public static String dataEntityBuffed_Tried = "CoroAI_HW_Buffed_AI_Tried";
    public static String dataEntityBuffed_AI_CounterLeap = "ai_counterattack";
    public static String dataEntityBuffed_AI_Lunge = "ai_lunge";
    public static String dataEntityBuffed_AI_Hoist = "ai_hoist";
    public static String dataEntityBuffed_AI_Digging = "ai_mining";
    public static String dataEntityBuffed_AI_ExplodeOnStuck = "ai_explodeonstuck";
    public static String dataEntityBuffed_AI_Omniscience = "ai_omniscience";
    public static String dataEntityBuffed_AI_AntiAir = "ai_antiair";
    public static String dataEntityBuffed_AI_Infernal = "ai_infernal";
    public static String dataEntityBuffed_AI_Attack_Melee = "ai_attack_melee";
    public static String dataEntityBuffed_Health = "attribute_health";
    public static String dataEntityBuffed_AttackDamage = "attribute_attackdamage";
    public static String dataEntityBuffed_Inventory = "inventory";
    public static String dataEntityBuffed_InventoryDifficultyScaled = "inventory_difficulty_scaled";
    public static String dataEntityBuffed_Speed = "attribute_speed";
    public static String dataEntityBuffed_Speed_Flying = "attribute_speed_flying";
    public static String dataEntityBuffed_XP = "xp";
    public static String dataEntityBuffed_MobDrops = "mob_drops";
    public static String dataEntityBuffed_Data = "CoroAI_HW_Buffed_Data";
    public static String dataEntityCmodJson = "cmodjson";
    public static String dataEntityEnhanced = "CoroAI_HW_Inv_Enhanced";
    public static String dataEntityEnhanceTried = "CoroAI_HW_Inv_EnhanceTried";
    public static String dataEntityWaveSpawned = "CoroAI_HW_Inv_WaveSpawned";
    public static String dataEntityInitialSpawn = "CoroAI_HW_InitialSpawn";
    public static double speedCap = 0.4;

    public static void registerAndApplyCmods(EntityCreature ent, List<DataCmod> cmods, float difficulty) {
        List<DataCmod> cmodsFlat = DeserializerAllJson.getCmodsFlattened(cmods);
        boolean flattenConditionalInventory = false;
        if (flattenConditionalInventory) {
            ListIterator<DataCmod> it = cmodsFlat.listIterator();
            while (it.hasNext()) {
                DataCmod cmod = it.next();
                if (!(cmod instanceof CmodInventoryDifficultyScaled)) continue;
                CmodInventory cmodInventory = null;
                for (CmodInventoryEntry entry : ((CmodInventoryDifficultyScaled)cmod).listInventories) {
                    if (!((double)difficulty >= entry.min) || !((double)difficulty <= entry.max)) continue;
                    cmodInventory = entry.inventory;
                    break;
                }
                if (cmodInventory == null) continue;
                it.set(cmodInventory);
            }
        }
        if (!ent.getEntityData().func_74764_b(dataEntityBuffed_Data)) {
            ent.getEntityData().func_74782_a(dataEntityBuffed_Data, (NBTBase)new NBTTagCompound());
        }
        NBTTagCompound data = ent.getEntityData().func_74775_l(dataEntityBuffed_Data);
        JsonArray array = DeserializerAllJson.serializeCmods(cmodsFlat);
        data.func_74778_a(dataEntityCmodJson, array.toString());
        for (DataCmod cmod : cmodsFlat) {
            CULog.dbg("applyBuff: " + cmod.cmod);
            UtilEntityBuffs.applyBuff(cmod.cmod, ent, difficulty);
        }
        for (DataCmod cmod : cmodsFlat) {
            CULog.dbg("applyBuffPost: " + cmod.cmod);
            UtilEntityBuffs.applyBuffPost(cmod.cmod, ent, difficulty);
        }
    }

    public static List<DataCmod> getAllCmodData(EntityCreature ent) {
        NBTTagCompound data = ent.getEntityData().func_74775_l(dataEntityBuffed_Data);
        String json = data.func_74779_i(dataEntityCmodJson);
        return DeserializerAllJson.deserializeCmods(json);
    }

    public static DataCmod getCmodData(EntityCreature ent, String cmodName) {
        NBTTagCompound data = ent.getEntityData().func_74775_l(dataEntityBuffed_Data);
        String json = data.func_74779_i(dataEntityCmodJson);
        List<DataCmod> cmods = DeserializerAllJson.deserializeCmods(json);
        for (DataCmod cmod : cmods) {
            if (!cmod.cmod.equals(cmodName)) continue;
            return cmod;
        }
        CoroUtil.dbg("warning, could not find cmod data for nane " + cmodName);
        return null;
    }

    public static void registerBuff(BuffBase buff) {
        lookupBuffs.put(buff.getTagName(), buff);
    }

    public static boolean hasBuff(EntityCreature ent, BuffBase buff) {
        return UtilEntityBuffs.hasBuff(ent, buff.getTagName());
    }

    public static boolean hasBuff(EntityCreature ent, String buff) {
        NBTTagCompound data = ent.getEntityData().func_74775_l(dataEntityBuffed_Data);
        return data.func_74767_n(buff);
    }

    public static boolean applyBuff(String buffName, EntityCreature ent, float difficulty) {
        if (lookupBuffs.containsKey(buffName)) {
            ent.getEntityData().func_74757_a(dataEntityBuffed, true);
            if (!ent.getEntityData().func_74764_b(dataEntityBuffed_Difficulty)) {
                ent.getEntityData().func_74776_a(dataEntityBuffed_Difficulty, difficulty);
            }
            return lookupBuffs.get(buffName).applyBuff(ent, difficulty);
        }
        CULog.dbg("failed to find buff applying class by name: " + buffName);
        return false;
    }

    public static void applyBuffPost(String buffName, EntityCreature ent, float difficulty) {
        if (lookupBuffs.containsKey(buffName)) {
            lookupBuffs.get(buffName).applyBuffPost(ent, difficulty);
        }
    }

    public static void applyBuffPostAll(EntityCreature ent, float difficulty) {
        List<String> buffs = UtilEntityBuffs.getAllBuffNames();
        NBTTagCompound data = ent.getEntityData().func_74775_l(dataEntityBuffed_Data);
        for (String buff : buffs) {
            if (!data.func_74767_n(buff)) continue;
            BuffBase buffObj = UtilEntityBuffs.getBuff(buff);
            if (buffObj != null) {
                CULog.dbg("applyBuffPostAll buff: " + buff);
                buffObj.applyBuffPost(ent, difficulty);
                continue;
            }
            CoroUtil.dbg("warning: unable to find buff by name of " + buff);
        }
    }

    public static List<String> getAllBuffNames() {
        return new ArrayList<String>(lookupBuffs.keySet());
    }

    public static BuffBase getBuff(String buff) {
        return lookupBuffs.get(buff);
    }

    public static void buff_RollDice(World world, EntityCreature ent, EntityPlayer playerClosest) {
    }

    public static void setEquipment(EntityCreature ent, EntityEquipmentSlot slot, ItemStack stack) {
        ent.func_184201_a(slot, stack);
        ent.func_184642_a(slot, 0.0f);
    }

    public static boolean hasTask(EntityCreature ent, Class taskToCheckFor, boolean isTargetTask) {
        EntityAITasks tasks = ent.field_70714_bg;
        if (isTargetTask) {
            tasks = ent.field_70715_bh;
        }
        boolean foundTask = false;
        for (Object entry2 : tasks.field_75782_a) {
            EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)entry2;
            if (!taskToCheckFor.isAssignableFrom(entry.field_75733_a.getClass())) continue;
            foundTask = true;
            break;
        }
        return foundTask;
    }

    public static boolean hasAi(EntityLiving entity, Class<? extends EntityAIBase> clazz) {
        return entity.field_70714_bg.field_75782_a.stream().anyMatch(task -> clazz.isAssignableFrom(task.field_75733_a.getClass()));
    }

    public static boolean addTask(EntityCreature ent, Class taskToInject, int priorityOfTask, boolean isTargetTask) {
        EntityAITasks tasks = ent.field_70714_bg;
        if (isTargetTask) {
            tasks = ent.field_70715_bh;
        }
        try {
            Constructor cons = taskToInject.getConstructor(new Class[0]);
            Object obj = cons.newInstance(new Object[0]);
            if (obj instanceof ITaskInitializer) {
                ITaskInitializer task = (ITaskInitializer)obj;
                task.setEntity(ent);
                tasks.func_75776_a(priorityOfTask, (EntityAIBase)task);
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void processLootTableOnEntity(EntityCreature ent, LootTable loottable, LivingDeathEvent event) {
        LootContext.Builder lootcontext$builder = new LootContext.Builder((WorldServer)ent.field_70170_p).func_186472_a((Entity)ent).func_186473_a(event.getSource());
        if (ent.field_70718_bc > 0 && ent.field_70717_bb != null) {
            lootcontext$builder = lootcontext$builder.func_186470_a(ent.field_70717_bb).func_186469_a(ent.field_70717_bb.func_184817_da());
        }
        for (ItemStack itemstack : loottable.func_186462_a(ent.field_70170_p.field_73012_v, lootcontext$builder.func_186471_a())) {
            ent.func_70099_a(itemstack, 0.0f);
        }
    }

    public static EquipmentForDifficulty getEquipmentItemsFromData(CmodInventory data) {
        Item item;
        Item item2;
        EquipmentForDifficulty equipment = new EquipmentForDifficulty();
        try {
            item2 = UtilEntityBuffs.getItemOrNull(data.inv_hand_main);
            if (item2 != null) {
                equipment.setWeapon(new ItemStack(item2));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            item2 = UtilEntityBuffs.getItemOrNull(data.inv_hand_off);
            if (item2 != null) {
                equipment.setWeaponOffhand(new ItemStack(item2));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        ArrayList<ItemStack> listArmor = new ArrayList<ItemStack>();
        try {
            item = UtilEntityBuffs.getItemOrNull(data.inv_head);
            if (item != null) {
                listArmor.add(new ItemStack(item));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            item = UtilEntityBuffs.getItemOrNull(data.inv_chest);
            if (item != null) {
                listArmor.add(new ItemStack(item));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            item = UtilEntityBuffs.getItemOrNull(data.inv_legs);
            if (item != null) {
                listArmor.add(new ItemStack(item));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            item = UtilEntityBuffs.getItemOrNull(data.inv_feet);
            if (item != null) {
                listArmor.add(new ItemStack(item));
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        equipment.setListArmor(listArmor);
        return equipment;
    }

    public static Item getItemOrNull(String name) {
        if (name == null || name.equals("")) {
            return null;
        }
        return Item.func_111206_d((String)name);
    }

    public static void onDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof EntityCreature) {
            EntityCreature ent = (EntityCreature)event.getEntityLiving();
            if (ent.field_70170_p.func_82736_K().func_82766_b("doMobLoot") && ent.getEntityData().func_74767_n(dataEntityBuffed)) {
                float difficultySpawnedIn = 0.0f;
                if (ent.getEntityData().func_74764_b(dataEntityBuffed_Difficulty)) {
                    difficultySpawnedIn = ent.getEntityData().func_74760_g(dataEntityBuffed_Difficulty);
                } else if (ent.field_70170_p.func_175667_e(ent.func_180425_c())) {
                    difficultySpawnedIn = DynamicDifficulty.getDifficultyAveragedForArea(ent);
                }
                List<String> buffs = UtilEntityBuffs.getAllBuffNames();
                NBTTagCompound data = ent.getEntityData().func_74775_l(dataEntityBuffed_Data);
                for (String buff : buffs) {
                    if (!data.func_74767_n(buff)) continue;
                    BuffBase buffObj = UtilEntityBuffs.getBuff(buff);
                    if (buffObj != null) {
                        buffObj.applyBuffOnDeath(ent, difficultySpawnedIn, event);
                        continue;
                    }
                    CoroUtil.dbg("warning: unable to find buff by name of " + buff);
                }
            }
        }
    }
}

