/*
 * Decompiled with CFR 0.152.
 */
package CoroUtil.util;

import CoroUtil.forge.CULog;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.client.Minecraft;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.ResourceLocation;

public class UtilProfile
implements Runnable {
    private static UtilProfile instance;
    private static Thread thread;
    public ConcurrentLinkedQueue<String> listProfileRequests = new ConcurrentLinkedQueue();
    public ConcurrentHashMap<UUID, CachedPlayerData> lookupUUIDToCachedData = new ConcurrentHashMap();
    public ConcurrentHashMap<String, CachedPlayerData> lookupNameToCachedData = new ConcurrentHashMap();

    public static UtilProfile getInstance() {
        if (instance == null) {
            instance = new UtilProfile();
        }
        return instance;
    }

    @Override
    public void run() {
        while (!this.listProfileRequests.isEmpty()) {
            String profile = this.listProfileRequests.peek();
            this.setupProfileData(new GameProfile(null, profile));
            this.listProfileRequests.poll();
        }
    }

    public void tryToAddProfileToLookupQueue(GameProfile profile) {
        if (!this.listProfileRequests.contains(profile.getName())) {
            CULog.dbg("requesting data for: " + profile.getName());
            this.listProfileRequests.add(profile.getName());
            if (thread == null || thread.getState() == Thread.State.TERMINATED) {
                thread = new Thread((Runnable)instance, "Player Profile Data Request Thread");
                thread.start();
            }
        }
    }

    public void setupProfileData(GameProfile profile) {
        try {
            String originalLookupName = profile.getName();
            profile = TileEntitySkull.func_174884_b((GameProfile)profile);
            CULog.dbg("got updated profile for " + originalLookupName + " (" + profile.getName() + "), uuid: " + profile.getId());
            if (profile != null) {
                MinecraftProfileTexture.Type type;
                CachedPlayerData data = new CachedPlayerData(profile);
                Minecraft minecraft = Minecraft.func_71410_x();
                Map map = minecraft.func_152342_ad().func_152788_a(profile);
                if (map.containsKey(type = MinecraftProfileTexture.Type.SKIN)) {
                    CULog.dbg("set temp data to load from gl context");
                    data.setTemp((MinecraftProfileTexture)map.get(type));
                } else {
                    CULog.dbg("error getting profile texture map data for name " + originalLookupName);
                }
                this.lookupNameToCachedData.put(originalLookupName, data);
                this.lookupUUIDToCachedData.put(profile.getId(), data);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public class CachedPlayerData {
        private GameProfile profile;
        private ResourceLocation texture;
        private boolean isSlim = false;
        private MinecraftProfileTexture temp;

        public CachedPlayerData(GameProfile profile) {
            this.profile = profile;
        }

        public GameProfile getProfile() {
            return this.profile;
        }

        public void setProfile(GameProfile profile) {
            this.profile = profile;
        }

        public ResourceLocation getTexture() {
            return this.texture;
        }

        public void setTexture(ResourceLocation texture) {
            this.texture = texture;
        }

        public boolean isSlim() {
            return this.isSlim;
        }

        public void setSlim(boolean slim) {
            this.isSlim = slim;
        }

        public MinecraftProfileTexture getTemp() {
            return this.temp;
        }

        public void setTemp(MinecraftProfileTexture temp) {
            this.temp = temp;
        }
    }
}

